/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;

public class TriggerExecutionOperation
extends AbstractOperation {
    public TriggerExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (!(currentFlowElement instanceof FlowNode)) throw new FlowableException("Programmatic error: no current flow element found or invalid type: " + currentFlowElement + ". Halting.");
        ActivityBehavior activityBehavior = (ActivityBehavior)((FlowNode)currentFlowElement).getBehavior();
        if (!(activityBehavior instanceof TriggerableActivityBehavior)) throw new FlowableException("Invalid behavior: " + activityBehavior + " should implement " + TriggerableActivityBehavior.class.getName());
        if (currentFlowElement instanceof BoundaryEvent) {
            this.commandContext.getHistoryManager().recordActivityStart(this.execution);
        }
        ((TriggerableActivityBehavior)activityBehavior).trigger(this.execution, null, null);
        if (!(currentFlowElement instanceof BoundaryEvent)) return;
        this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
    }
}

