/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.util.Map;
import org.flowable.content.api.ContentService;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.api.DmnRuleService;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.common.impl.cfg.TransactionContextFactory;
import org.flowable.engine.common.impl.interceptor.SessionFactory;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.SchemaOperationsProcessEngineBuild;
import org.flowable.engine.impl.asyncexecutor.AsyncExecutor;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cfg.TransactionListener;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.interceptor.CommandExecutor;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.idm.api.IdmIdentityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEngineImpl
implements ProcessEngine {
    private static Logger log = LoggerFactory.getLogger(ProcessEngineImpl.class);
    protected String name;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected HistoryService historicDataService;
    protected IdentityService identityService;
    protected TaskService taskService;
    protected FormService formService;
    protected ManagementService managementService;
    protected DynamicBpmnService dynamicBpmnService;
    protected FormRepositoryService formEngineRepositoryService;
    protected org.flowable.form.api.FormService formEngineFormService;
    protected DmnRepositoryService dmnRepositoryService;
    protected DmnRuleService dmnRuleService;
    protected IdmIdentityService idmIdentityService;
    protected ContentService contentService;
    protected AsyncExecutor asyncExecutor;
    protected CommandExecutor commandExecutor;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected TransactionContextFactory<TransactionListener, CommandContext> transactionContextFactory;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.name = processEngineConfiguration.getEngineName();
        this.repositoryService = processEngineConfiguration.getRepositoryService();
        this.runtimeService = processEngineConfiguration.getRuntimeService();
        this.historicDataService = processEngineConfiguration.getHistoryService();
        this.identityService = processEngineConfiguration.getIdentityService();
        this.taskService = processEngineConfiguration.getTaskService();
        this.formService = processEngineConfiguration.getFormService();
        this.managementService = processEngineConfiguration.getManagementService();
        this.dynamicBpmnService = processEngineConfiguration.getDynamicBpmnService();
        this.asyncExecutor = processEngineConfiguration.getAsyncExecutor();
        this.commandExecutor = processEngineConfiguration.getCommandExecutor();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.transactionContextFactory = processEngineConfiguration.getTransactionContextFactory();
        this.formEngineRepositoryService = processEngineConfiguration.getFormEngineRepositoryService();
        this.formEngineFormService = processEngineConfiguration.getFormEngineFormService();
        this.dmnRepositoryService = processEngineConfiguration.getDmnEngineRepositoryService();
        this.dmnRuleService = processEngineConfiguration.getDmnEngineRuleService();
        this.idmIdentityService = processEngineConfiguration.getIdmIdentityService();
        this.contentService = processEngineConfiguration.getContentService();
        if (processEngineConfiguration.isUsingRelationalDatabase() && processEngineConfiguration.getDatabaseSchemaUpdate() != null) {
            this.commandExecutor.execute(processEngineConfiguration.getSchemaCommandConfig(), new SchemaOperationsProcessEngineBuild());
        }
        if (this.name == null) {
            log.info("default ProcessEngine created");
        } else {
            log.info("ProcessEngine {} created", (Object)this.name);
        }
        ProcessEngines.registerProcessEngine(this);
        if (processEngineConfiguration.getProcessEngineLifecycleListener() != null) {
            processEngineConfiguration.getProcessEngineLifecycleListener().onProcessEngineBuilt(this);
        }
        processEngineConfiguration.getEventDispatcher().dispatchEvent(FlowableEventBuilder.createGlobalEvent(FlowableEngineEventType.ENGINE_CREATED));
        if (this.asyncExecutor != null && this.asyncExecutor.isAutoActivate()) {
            this.asyncExecutor.start();
        }
    }

    @Override
    public void close() {
        Runnable closeRunnable;
        ProcessEngines.unregister(this);
        if (this.asyncExecutor != null && this.asyncExecutor.isActive()) {
            this.asyncExecutor.shutdown();
        }
        if ((closeRunnable = this.processEngineConfiguration.getProcessEngineCloseRunnable()) != null) {
            closeRunnable.run();
        }
        if (this.processEngineConfiguration.getProcessEngineLifecycleListener() != null) {
            this.processEngineConfiguration.getProcessEngineLifecycleListener().onProcessEngineClosed(this);
        }
        this.processEngineConfiguration.getEventDispatcher().dispatchEvent(FlowableEventBuilder.createGlobalEvent(FlowableEngineEventType.ENGINE_CLOSED));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IdentityService getIdentityService() {
        return this.identityService;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public TaskService getTaskService() {
        return this.taskService;
    }

    @Override
    public HistoryService getHistoryService() {
        return this.historicDataService;
    }

    @Override
    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    @Override
    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public FormService getFormService() {
        return this.formService;
    }

    @Override
    public DynamicBpmnService getDynamicBpmnService() {
        return this.dynamicBpmnService;
    }

    @Override
    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    @Override
    public FormRepositoryService getFormEngineRepositoryService() {
        return this.formEngineRepositoryService;
    }

    @Override
    public org.flowable.form.api.FormService getFormEngineFormService() {
        return this.formEngineFormService;
    }

    @Override
    public DmnRepositoryService getDmnRepositoryService() {
        return this.dmnRepositoryService;
    }

    @Override
    public DmnRuleService getDmnRuleService() {
        return this.dmnRuleService;
    }

    @Override
    public IdmIdentityService getIdmIdentityService() {
        return this.idmIdentityService;
    }

    @Override
    public ContentService getContentService() {
        return this.contentService;
    }
}

