/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.frames.ControlFrame;

public abstract class ControlFrameGenerator {
    private final ByteBufferPool bufferPool;

    protected ControlFrameGenerator(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    protected ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public abstract ByteBuffer generate(ControlFrame var1);

    protected void generateControlFrameHeader(ControlFrame frame, int frameLength, ByteBuffer buffer) {
        buffer.putShort((short)(32768 + frame.getVersion()));
        buffer.putShort(frame.getType().getCode());
        int flagsAndLength = frame.getFlags();
        flagsAndLength <<= 24;
        buffer.putInt(flagsAndLength += frameLength);
    }
}

