/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fest.reflect.field.FieldType;
import org.fest.reflect.field.FieldTypeRef;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.Strings;

public final class FieldName {
    private final String name;
    private final List<String> path;

    public static FieldName beginFieldAccess(String name) {
        FieldName.validateIsNotNullOrEmpty(name);
        return new FieldName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the field to access should not be null");
        }
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name of the field to access should not be empty");
        }
    }

    private FieldName(String name) {
        this.path = new ArrayList<String>(Arrays.asList(name.split("\\.")));
        this.path.remove(this.path.size() - 1);
        this.name = name.substring(name.lastIndexOf(46) + 1, name.length());
    }

    public <T> FieldType<T> ofType(Class<T> type) {
        return FieldType.newFieldType(this.name, type, this.path);
    }

    public <T> FieldTypeRef<T> ofType(TypeRef<T> type) {
        return FieldTypeRef.newFieldTypeRef(this.name, type, this.path);
    }
}

