/*
 * Decompiled with CFR 0.152.
 */
package daverog.jsonld.tree;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import daverog.jsonld.tree.DirectionalPredicate;
import daverog.jsonld.tree.NameResolver;
import daverog.jsonld.tree.RdfTree;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdfTreeJsonWriter {
    public String asJson(RdfTree tree) {
        tree.canonicalise();
        if (tree.isEmpty()) {
            return "{}";
        }
        if (tree.isList()) {
            LinkedHashMap json = Maps.newLinkedHashMap();
            ArrayList list = Lists.newArrayList();
            this.populateJsonArray(tree, list);
            json.put("results", list);
            TreeMap nameUriMap = Maps.newTreeMap(this.getPrefixedNameUriMap(tree));
            nameUriMap.put("results", new TreeMap(ImmutableMap.of((Object)"@id", (Object)"@graph")));
            json.put("@context", nameUriMap);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson((Object)json);
        }
        LinkedHashMap json = Maps.newLinkedHashMap();
        this.populateJsonObject(tree, json);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)json);
    }

    private void populateJsonArray(RdfTree tree, List<Object> array) {
        for (RdfTree childTree : tree.getChildren()) {
            LinkedHashMap arrayItem = Maps.newLinkedHashMap();
            this.populateJsonObject(childTree, arrayItem);
            array.add(arrayItem);
        }
    }

    private String getName(RdfTree tree, Resource resource) {
        String name = tree.getNameResolver().getName(resource);
        name = name.equals("type") ? "@type" : tree.getNameResolver().getPrefixedName(resource);
        return name;
    }

    private void populateJsonObject(RdfTree tree, LinkedHashMap<String, Object> json) {
        json.put("@id", tree.getNode().asResource().getURI());
        for (List<RdfTree> childTrees : this.getGroupedChildren(tree).values()) {
            if (childTrees.isEmpty()) continue;
            RdfTree firstChildTree = childTrees.get(0);
            if (childTrees.size() == 1) {
                if (firstChildTree.isChildlessResource()) {
                    if (firstChildTree.getPredicate() != null && firstChildTree.getPredicate().getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                        this.addPredicateValue(json, tree, firstChildTree, Lists.newArrayList((Object[])new String[]{this.getName(tree, firstChildTree.getNode().asResource())}));
                        continue;
                    }
                    this.addPredicateValue(json, tree, firstChildTree, this.getName(tree, firstChildTree.getNode().asResource()));
                    continue;
                }
                if (firstChildTree.getNode().isResource()) {
                    LinkedHashMap child = Maps.newLinkedHashMap();
                    this.populateJsonObject(firstChildTree, child);
                    ArrayList array = Lists.newArrayList((Object[])new Object[]{child});
                    this.addPredicateValue(json, tree, firstChildTree, array);
                    continue;
                }
                this.addPredicateValue(json, tree, firstChildTree, this.convertToJsonLiteral(firstChildTree.getNode().asLiteral()));
                continue;
            }
            ArrayList array = Lists.newArrayList();
            for (RdfTree childTree : childTrees) {
                if (childTree.isChildlessResource()) {
                    array.add(this.getName(tree, childTree.getNode().asResource()));
                    continue;
                }
                if (childTree.getNode().isResource()) {
                    LinkedHashMap child = Maps.newLinkedHashMap();
                    this.populateJsonObject(childTree, child);
                    array.add(child);
                    continue;
                }
                array.add(this.convertToJsonLiteral(childTree.getNode().asLiteral()));
            }
            this.addPredicateValue(json, tree, firstChildTree, array);
        }
        SortedMap<String, SortedMap<String, String>> nameUriMap = this.getPrefixedNameUriMap(tree);
        if (tree.isRoot() && !nameUriMap.isEmpty()) {
            json.put("@context", nameUriMap);
        }
    }

    private void addPredicateValue(LinkedHashMap<String, Object> json, RdfTree tree, RdfTree childTree, Object value) {
        String predicateName = this.getName(tree, (Resource)childTree.getPredicate());
        if (childTree.isInverse()) {
            Map reverse = (Map)json.get("@reverse");
            if (reverse == null) {
                reverse = Maps.newHashMap();
                json.put("@reverse", reverse);
            }
            reverse.put(predicateName, value);
        } else {
            json.put(predicateName, value);
        }
    }

    private Object convertToJsonLiteral(Literal literal) {
        if (Number.class.isAssignableFrom(literal.getValue().getClass())) {
            return literal.getValue();
        }
        return literal.getLexicalForm();
    }

    public Map<DirectionalPredicate, List<RdfTree>> getGroupedChildren(RdfTree tree) {
        LinkedHashMap groupedChildren = Maps.newLinkedHashMap();
        for (RdfTree childTree : tree.getChildren()) {
            List childrenForDirectionalPredicate = (List)groupedChildren.get(childTree.getDirectionalPredicate());
            if (childrenForDirectionalPredicate == null) {
                childrenForDirectionalPredicate = Lists.newArrayList();
                groupedChildren.put(childTree.getDirectionalPredicate(), childrenForDirectionalPredicate);
            }
            childrenForDirectionalPredicate.add(childTree);
        }
        return groupedChildren;
    }

    public SortedMap<String, SortedMap<String, String>> getNameUriMap(RdfTree tree) {
        return Maps.transformValues(tree.getNameResolver().getMappedResources(), (Function)new Function<NameResolver.TypedResource, SortedMap<String, String>>(){

            public SortedMap<String, String> apply(NameResolver.TypedResource resource) {
                TreeMap uriData = Maps.newTreeMap();
                uriData.put("@id", resource.getResource().getNameSpace());
                switch (resource.getType()) {
                    case VOCAB: {
                        uriData.put("@type", "@vocab");
                        break;
                    }
                    case ID: {
                        uriData.put("@type", "@id");
                    }
                }
                return uriData;
            }
        });
    }

    public SortedMap<String, SortedMap<String, String>> getPrefixedNameUriMap(RdfTree tree) {
        TreeMap<String, NameResolver.TypedResource> prefixedNameUriMap = new TreeMap<String, NameResolver.TypedResource>();
        for (Map.Entry<String, NameResolver.TypedResource> entry : tree.getNameResolver().getMappedResources().entrySet()) {
            Resource resource = entry.getValue().getResource();
            String name = tree.getNameResolver().getPrefixedName(resource);
            prefixedNameUriMap.put(name, entry.getValue());
        }
        return Maps.transformValues(prefixedNameUriMap, (Function)new Function<NameResolver.TypedResource, SortedMap<String, String>>(){

            public SortedMap<String, String> apply(NameResolver.TypedResource resource) {
                TreeMap uriData = Maps.newTreeMap();
                uriData.put("@id", resource.getResource().getURI());
                switch (resource.getType()) {
                    case VOCAB: {
                        uriData.put("@type", "@vocab");
                        break;
                    }
                    case ID: {
                        uriData.put("@type", "@id");
                    }
                }
                return uriData;
            }
        });
    }
}

