/*
 * Decompiled with CFR 0.152.
 */
package daverog.jsonld.tree;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import daverog.jsonld.tree.NameResolver;
import daverog.jsonld.tree.RdfTree;
import daverog.jsonld.tree.RdfTreeException;
import daverog.jsonld.tree.RdfTreeUtils;
import daverog.jsonld.tree.RdfTreeValidator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdfTreeGenerator {
    private final String rdfResultOntologyPrefix;

    public RdfTreeGenerator() {
        this.rdfResultOntologyPrefix = "http://purl.org/ontology/rdf-result/";
    }

    public RdfTreeGenerator(String rdfResultOntologyPrefix) {
        this.rdfResultOntologyPrefix = rdfResultOntologyPrefix;
    }

    public RdfTree generateRdfTree(Model model) throws RdfTreeException {
        return this.generateRdfTree(model, Lists.newArrayList(), Maps.newHashMap());
    }

    public RdfTree generateRdfTree(Model model, Map<String, String> nameOverrides) throws RdfTreeException {
        RdfTreeValidator rdfTreeValidator = new RdfTreeValidator();
        rdfTreeValidator.KeysCannotHaveSameValue(nameOverrides);
        return this.generateRdfTree(model, Lists.newArrayList(), nameOverrides);
    }

    public RdfTree generateRdfTree(Model model, List<String> prioritisedNamespaces) throws RdfTreeException {
        return this.generateRdfTree(model, prioritisedNamespaces, Maps.newHashMap());
    }

    public RdfTree generateRdfTree(Model model, List<String> prioritisedNamespaces, Map<String, String> nameOverrides) throws RdfTreeException {
        NameResolver nameResolver = new NameResolver(model, prioritisedNamespaces, nameOverrides, this.rdfResultOntologyPrefix);
        TreeType treeType = TreeType.UNKNOWN;
        if (model.isEmpty()) {
            return new RdfTree(model, nameResolver, null);
        }
        List<Statement> results = this.getSomeStatements(model, new SimpleSelector(model.getResource(this.rdfResultOntologyPrefix + "this"), null, (RDFNode)null), "result:this is not present as the subject of a statement, so an RDF tree cannot be generated");
        Statement firstResult = results.get(0);
        Resource orderingPredicate = null;
        boolean sortAscending = true;
        List<Object> listItems = Lists.newArrayList();
        for (Statement result : results) {
            if (!result.getObject().isResource()) {
                throw new RdfTreeException("result:this statement contained a non-resource object");
            }
            if (result.getPredicate().getURI().equals(this.rdfResultOntologyPrefix + "item")) {
                if (results.size() != 1) {
                    throw new RdfTreeException("More than one result:this subject was found for a single item result");
                }
                if (treeType == TreeType.UNKNOWN) {
                    treeType = TreeType.ITEM;
                } else {
                    throw new RdfTreeException("Tree type " + (Object)((Object)treeType) + " was identified alongside conflicting predicate result:item");
                }
            }
            if (result.getPredicate().getURI().equals(this.rdfResultOntologyPrefix + "next")) {
                if (results.size() != 1) {
                    throw new RdfTreeException("More than one starting point was found for a list described by result:next");
                }
                if (treeType == TreeType.UNKNOWN) {
                    treeType = TreeType.LIST;
                } else {
                    throw new RdfTreeException("Tree type " + (Object)((Object)treeType) + " was identified alongside conflicting predicate result:next");
                }
            }
            if (!result.getPredicate().getURI().equals(this.rdfResultOntologyPrefix + "listItem")) continue;
            if (treeType != TreeType.UNKNOWN && treeType != TreeType.LIST_WITH_ORDER_BY_PREDICATE) {
                throw new RdfTreeException("Tree type " + (Object)((Object)treeType) + " was identified alongside conflicting predicate result:listItem");
            }
            treeType = TreeType.LIST_WITH_ORDER_BY_PREDICATE;
            listItems.add(result.getObject().asResource());
        }
        for (Statement result : results) {
            if (result.getPredicate().getURI().equals(this.rdfResultOntologyPrefix + "orderByPredicate")) {
                if (orderingPredicate != null) {
                    throw new RdfTreeException("More than one ordering predicate was supplied.");
                }
                if (treeType != TreeType.LIST_WITH_ORDER_BY_PREDICATE) {
                    throw new RdfTreeException("An ordering predicate was supplied for tree type " + (Object)((Object)treeType));
                }
                orderingPredicate = result.getObject().asResource();
            }
            if (!result.getPredicate().getURI().equals(this.rdfResultOntologyPrefix + "sortOrder")) continue;
            if (treeType != TreeType.LIST_WITH_ORDER_BY_PREDICATE) {
                throw new RdfTreeException("An sort order was supplied for tree type " + (Object)((Object)treeType));
            }
            if (!result.getObject().isResource()) {
                throw new RdfTreeException("An sort order was not a resource");
            }
            Resource sortOrder = result.getObject().asResource();
            if (sortOrder.getURI().equals(this.rdfResultOntologyPrefix + "AscendingOrder")) {
                sortAscending = true;
                continue;
            }
            if (sortOrder.getURI().equals(this.rdfResultOntologyPrefix + "DescendingOrder")) {
                sortAscending = false;
                continue;
            }
            throw new RdfTreeException("Unknown sort order: " + result.getObject().asResource().getURI());
        }
        if (treeType == TreeType.ITEM) {
            return this.buildRdfTree(model, new RdfTree(model, nameResolver, firstResult.getObject()));
        }
        if (treeType == TreeType.LIST) {
            return this.buildRdfList(model, nameResolver, this.generateListItemsUsingResultNext(model, firstResult.getObject().asResource()));
        }
        if (treeType == TreeType.LIST_WITH_ORDER_BY_PREDICATE) {
            listItems = this.sortListAccordingToOrderingPredicate((List<Resource>)listItems, orderingPredicate, sortAscending, model);
            return this.buildRdfList(model, nameResolver, (List<Resource>)listItems);
        }
        throw new RdfTreeException("The tree type could not be identified, the necessary result:this statements were not present");
    }

    private List<Resource> sortListAccordingToOrderingPredicate(List<Resource> listItems, final Resource orderingPredicate, boolean sortAscending, final Model model) {
        Collections.sort(listItems, new Comparator<Resource>(){

            @Override
            public int compare(Resource first, Resource second) {
                List firstValues = RdfTreeGenerator.this.getAllValuesForSubjectAndPredicate(model, first, orderingPredicate);
                List secondValues = RdfTreeGenerator.this.getAllValuesForSubjectAndPredicate(model, second, orderingPredicate);
                return RdfTreeUtils.compareTwoListsOfValues(firstValues, secondValues, new Comparator<RDFNode>(){

                    @Override
                    public int compare(RDFNode node1, RDFNode node2) {
                        if (node1.isLiteral() && !node2.isLiteral()) {
                            return -1;
                        }
                        if (!node1.isLiteral() && node2.isLiteral()) {
                            return 1;
                        }
                        if (node1.isLiteral() && node2.isLiteral()) {
                            Object value1 = node1.asLiteral().getValue();
                            Object value2 = node2.asLiteral().getValue();
                            if (value1 instanceof String && !(value2 instanceof String)) {
                                return -1;
                            }
                            if (!(value1 instanceof String) && value2 instanceof String) {
                                return 1;
                            }
                            return RdfTreeUtils.compareObjects(node1.asLiteral().getValue(), node2.asLiteral().getValue());
                        }
                        return RdfTreeUtils.compareObjects(node1, node2);
                    }
                });
            }
        });
        if (!sortAscending) {
            Collections.reverse(listItems);
        }
        return listItems;
    }

    private List<RDFNode> getAllValuesForSubjectAndPredicate(Model model, Resource subject, Resource predicate) {
        Property property = predicate == null ? null : model.getProperty(predicate.getURI());
        List statements = model.listStatements((Selector)new SimpleSelector(subject, property, (RDFNode)null)).toList();
        return Lists.transform((List)statements, (Function)new Function<Statement, RDFNode>(){

            public RDFNode apply(Statement statement) {
                return statement.getObject();
            }
        });
    }

    private List<Resource> generateListItemsUsingResultNext(Model model, Resource firstItem) throws RdfTreeException {
        Statement next = this.getNoneOrSingleStatement(model, new SimpleSelector(firstItem, model.getProperty(this.rdfResultOntologyPrefix + "next"), (RDFNode)null), "too many result:next predicates assigned to " + firstItem.toString());
        if (next != null) {
            if (!next.getObject().isResource()) {
                throw new RdfTreeException("result:next cannot be a literal or blank node");
            }
            return Lists.asList((Object)firstItem, (Object[])this.generateListItemsUsingResultNext(model, next.getObject().asResource()).toArray(new Resource[0]));
        }
        return Lists.newArrayList((Object[])new Resource[]{firstItem});
    }

    private RdfTree buildRdfTree(Model model, RdfTree root) {
        while (!root.isFullyConstructed()) {
            this.expandRdfTree(model, null, root);
        }
        return root;
    }

    private RdfTree buildRdfList(Model model, NameResolver nameResolver, List<Resource> listItems) throws RdfTreeException {
        RdfTree list = new RdfTree(model, nameResolver);
        for (Resource listItem : listItems) {
            list.addListItem(listItem);
        }
        while (!list.isFullyConstructed()) {
            for (RdfTree childTree : list.getChildren()) {
                this.expandRdfTree(model, list, childTree);
            }
        }
        return list;
    }

    private RdfTree expandRdfTree(Model model, RdfTree root, RdfTree current) {
        if (!current.isConstructed()) {
            if (current.getNode().isResource()) {
                if (root == null) {
                    root = current;
                }
                List statements = model.listStatements((Selector)new SimpleSelector(current.getNode().asResource(), null, (RDFNode)null)).toList();
                List inverseStatements = model.listStatements((Selector)new SimpleSelector(null, null, current.getNode())).toList();
                inverseStatements.removeAll(statements);
                List types = model.listStatements((Selector)new SimpleSelector(current.getNode().asResource(), model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)null)).toList();
                if (types.size() == 1) {
                    current.setType(((Statement)types.get(0)).getObject().asResource());
                }
                this.handleStatements(model, current, statements, false);
                this.handleStatements(model, current, inverseStatements, true);
            }
            current.markAsConstructed();
        } else {
            for (RdfTree childTree : current.getChildren()) {
                this.expandRdfTree(model, root, childTree);
            }
        }
        return current;
    }

    private void handleStatements(Model model, RdfTree current, List<Statement> statements, boolean inverse) {
        for (Statement statement : statements) {
            if (statement.getPredicate().getNameSpace().equals(this.rdfResultOntologyPrefix)) continue;
            current.addChild(statement);
        }
    }

    private List<Statement> getSomeStatements(Model model, SimpleSelector selector, String notFoundMessage) throws RdfTreeException {
        StmtIterator statements = model.listStatements((Selector)selector);
        if (!statements.hasNext()) {
            throw new RdfTreeException(notFoundMessage);
        }
        return statements.toList();
    }

    private Statement getNoneOrSingleStatement(Model model, SimpleSelector selector, String tooManyMessage) throws RdfTreeException {
        StmtIterator statements = model.listStatements((Selector)selector);
        if (!statements.hasNext()) {
            return null;
        }
        Statement only = statements.nextStatement();
        if (statements.hasNext()) {
            throw new RdfTreeException(tooManyMessage);
        }
        return only;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TreeType {
        UNKNOWN,
        ITEM,
        LIST,
        LIST_WITH_ORDER_BY_PREDICATE;

    }
}

