/*
 * Decompiled with CFR 0.152.
 */
package daverog.jsonld.tree;

import com.google.common.collect.Lists;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import daverog.jsonld.tree.DirectionalPredicate;
import daverog.jsonld.tree.NameResolver;
import daverog.jsonld.tree.RdfTreeJsonWriter;
import daverog.jsonld.tree.RdfTreeUtils;
import daverog.jsonld.tree.RdfTreeXmlWriter;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdfTree
implements Comparable<RdfTree> {
    public static final String DEFAULT_RESULT_ONTOLOGY_URI_PREFIX = "http://purl.org/ontology/rdf-result/";
    public static final String RDF_PREFIX = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    public static final String OWL_PREFIX = "http://www.w3.org/2002/07/owl#";
    private final RdfTree parent;
    private List<RdfTree> children = Lists.newArrayList();
    private final boolean inverse;
    private final boolean list;
    private final RDFNode node;
    private final Property predicate;
    private final Model model;
    private final NameResolver nameResolver;
    private Resource type;
    private boolean constructed = false;

    public RdfTree(Model model, NameResolver nameResolver, RdfTree parent, RDFNode node, Property predicate, boolean inverse) {
        this.model = model;
        this.nameResolver = nameResolver;
        this.parent = parent;
        this.node = node;
        this.predicate = predicate;
        this.inverse = inverse;
        this.list = false;
    }

    public RdfTree(Model model, NameResolver nameResolver, RDFNode rootNode) {
        this.model = model;
        this.nameResolver = nameResolver;
        this.node = rootNode;
        this.list = false;
        this.predicate = null;
        this.inverse = false;
        this.parent = null;
    }

    public RdfTree(Model model, NameResolver nameResolver) {
        this.model = model;
        this.nameResolver = nameResolver;
        this.list = true;
        this.predicate = null;
        this.inverse = false;
        this.parent = null;
        this.node = null;
    }

    public void addChild(Statement statement) {
        boolean hasSiblingOrAncestorSibling;
        Resource childNode = statement.getSubject();
        boolean inverse = true;
        if (statement.getSubject().equals(this.getNode())) {
            childNode = statement.getObject();
            inverse = false;
        }
        if (statement.getPredicate().getURI().equals(RDF_TYPE) && inverse) {
            return;
        }
        if (this.hasParentWithNode((RDFNode)childNode)) {
            return;
        }
        if (this.parent != null && !this.parent.isList() && this.parent.getNode() != null && this.hasListRootWithNode(this.getNode())) {
            return;
        }
        if (this.parent != null && this.getPredicate() != null && this.getPredicate().equals(statement.getPredicate()) && this.isInverse() != inverse && this.hasListRootWithNode((RDFNode)childNode)) {
            return;
        }
        int depthOfPotentialChild = this.getDepth() + 1;
        boolean bl = hasSiblingOrAncestorSibling = depthOfPotentialChild >= this.getDepthInTree(this.node);
        if (this.parent != null && this.getPredicate() != null && inverse && hasSiblingOrAncestorSibling) {
            return;
        }
        this.children.add(new RdfTree(this.model, this.nameResolver, this, (RDFNode)childNode, statement.getPredicate(), inverse));
    }

    public void addListItem(Resource listItem) {
        this.children.add(new RdfTree(this.model, this.nameResolver, this, (RDFNode)listItem, null, false));
    }

    public Property getPredicate() {
        return this.predicate;
    }

    public RDFNode getNode() {
        return this.node;
    }

    public List<RdfTree> getChildren() {
        return this.children;
    }

    public DirectionalPredicate getDirectionalPredicate() {
        return new DirectionalPredicate(this.getPredicate(), this.inverse);
    }

    public void setType(Resource type) {
        this.type = type;
    }

    public boolean hasParentWithNode(RDFNode node) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.getNode() == null) {
            return false;
        }
        if (this.parent.getNode().equals(node)) {
            return true;
        }
        return this.parent.hasParentWithNode(node);
    }

    public boolean hasListRootWithNode(RDFNode node) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isList()) {
            return this.parent.hasListItemWithNode(node);
        }
        return this.parent.hasListRootWithNode(node);
    }

    private int getDepthInTree(RDFNode node) {
        return this.getRoot().getDepth(node);
    }

    private int getDepth(RDFNode node) {
        int depth = -1;
        if (this.getNode() != null && this.getNode().equals(node)) {
            depth = 0;
        } else {
            for (RdfTree child : this.children) {
                int depthInChild = child.getDepth(node);
                if (depthInChild == -1) continue;
                if (depth == -1) {
                    depth = depthInChild + 1;
                    continue;
                }
                if (depthInChild >= depth) continue;
                depth = depthInChild + 1;
            }
        }
        return depth;
    }

    private RdfTree getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    private int getDepth() {
        if (this.parent == null) {
            return 1;
        }
        if (this.parent.isList()) {
            return 0;
        }
        return this.parent.getDepth() + 1;
    }

    private boolean hasListItemWithNode(RDFNode node) {
        if (!this.list) {
            return false;
        }
        for (RdfTree childTree : this.children) {
            if (!childTree.getNode().equals(node)) continue;
            return true;
        }
        return false;
    }

    public void canonicalise() {
        for (RdfTree childTree : this.children) {
            childTree.canonicalise();
        }
        if (!this.list) {
            Collections.sort(this.children);
        }
    }

    private boolean isLiteral() {
        return this.getNode().isLiteral();
    }

    public boolean isType() {
        return this.getPredicate() != null && this.getPredicate().getURI().equals(RDF_TYPE) && !this.inverse;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public Resource getType() {
        return this.type;
    }

    @Override
    public int compareTo(RdfTree tree) {
        if (this.isType() && tree.isType()) {
            return 0;
        }
        if (this.isType() && !tree.isType()) {
            return -1;
        }
        if (!this.isType() && tree.isType()) {
            return 1;
        }
        if (this.inverse && !tree.inverse) {
            return 1;
        }
        if (!this.inverse && tree.inverse) {
            return -1;
        }
        if (this.isLiteral() && !tree.isLiteral()) {
            return -1;
        }
        if (!this.isLiteral() && tree.isLiteral()) {
            return 1;
        }
        if (this.isChildlessResource() && !tree.isChildlessResource()) {
            return -1;
        }
        if (!this.isChildlessResource() && tree.isChildlessResource()) {
            return 1;
        }
        if (this.getPredicate().equals(tree.getPredicate())) {
            if (this.isLiteral() && tree.isLiteral()) {
                return RdfTreeUtils.compareObjects(this.getNode().asLiteral().getValue(), tree.getNode().asLiteral().getValue());
            }
            return RdfTreeUtils.compareObjects(this.getNode(), tree.getNode());
        }
        return this.nameResolver.compareNames((Resource)this.getPredicate(), (Resource)tree.getPredicate());
    }

    public String asXml() {
        return new RdfTreeXmlWriter().asXml(this);
    }

    public String asHtml(String relativeUrlBase) {
        return new RdfTreeXmlWriter().asHtml(this, relativeUrlBase);
    }

    public String asJson() {
        return new RdfTreeJsonWriter().asJson(this);
    }

    public boolean isList() {
        return this.list;
    }

    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    public boolean isChildlessResource() {
        return this.node.isResource() && this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isEmpty() {
        return this.children.isEmpty() && this.node == null;
    }

    public int getDepthOf(String uri) {
        return this.getDepth((RDFNode)this.model.createResource(uri));
    }

    public boolean isFullyConstructed() {
        if (this.children.isEmpty()) {
            return this.constructed;
        }
        boolean fullyConstructed = true;
        for (RdfTree childTree : this.children) {
            if (childTree.isFullyConstructed()) continue;
            fullyConstructed = false;
        }
        return fullyConstructed;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public void markAsConstructed() {
        this.constructed = true;
    }
}

