/*
 * Decompiled with CFR 0.152.
 */
package daverog.jsonld.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameResolver {
    private final Model model;
    private final SortedMap<String, TypedResource> mappedResources;
    private final List<String> prioritisedNamespaces;
    private Map<String, String> nameOverrides;
    private final String rdfResultOntologyPrefix;

    public NameResolver(Model model, List<String> prioritisedNamespaces, Map<String, String> nameOverrides, String rdfResultOntologyPrefix) {
        this.model = model;
        this.nameOverrides = nameOverrides;
        this.rdfResultOntologyPrefix = rdfResultOntologyPrefix;
        this.prioritisedNamespaces = Lists.newArrayList((Object[])new String[]{"http://www.w3.org/1999/02/22-rdf-syntax-ns#", "http://www.w3.org/2002/07/owl#"});
        this.prioritisedNamespaces.addAll(prioritisedNamespaces);
        this.mappedResources = Maps.newTreeMap();
        StmtIterator statements = model.listStatements();
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            this.registerResource(new TypedResource(statement.getSubject(), ResourceType.NONE));
            ResourceType type = ResourceType.NONE;
            if (statement.getObject().isResource()) {
                Resource objectResource = statement.getObject().asResource();
                type = objectResource.getNameSpace() != null && model.getNsURIPrefix(objectResource.getNameSpace()) != null ? ResourceType.VOCAB : ResourceType.ID;
                this.registerResource(new TypedResource(objectResource, ResourceType.NONE));
            }
            this.registerResource(new TypedResource((Resource)statement.getPredicate(), type));
        }
    }

    private void registerResource(TypedResource resource) {
        String currentNamespace;
        String prefix;
        if (resource.getResource().getNameSpace() != null && !resource.getResource().getNameSpace().equals(this.rdfResultOntologyPrefix) && (prefix = this.model.getNsURIPrefix(currentNamespace = resource.getResource().getNameSpace())) != null && currentNamespace != null) {
            TypedResource existingResource = (TypedResource)this.mappedResources.get(resource.getResource().getLocalName());
            if (existingResource == null) {
                this.mappedResources.put(resource.getResource().getLocalName(), resource);
            } else if (!resource.getResource().equals(existingResource.getResource())) {
                boolean existingIsHigherPriorityThanCurrent = false;
                String existingNamespace = existingResource.getResource().getNameSpace();
                int priorityOfExistingResource = this.prioritisedNamespaces.indexOf(existingNamespace);
                int priorityOfCurrentResource = this.prioritisedNamespaces.indexOf(currentNamespace);
                if (priorityOfExistingResource == -1 && priorityOfCurrentResource == -1) {
                    existingIsHigherPriorityThanCurrent = existingNamespace.compareTo(currentNamespace) < 0;
                } else if (priorityOfExistingResource == -1 && priorityOfCurrentResource != -1) {
                    existingIsHigherPriorityThanCurrent = false;
                } else if (priorityOfExistingResource != -1 && priorityOfCurrentResource == -1) {
                    existingIsHigherPriorityThanCurrent = true;
                } else {
                    boolean bl = existingIsHigherPriorityThanCurrent = priorityOfExistingResource < priorityOfCurrentResource;
                }
                if (existingIsHigherPriorityThanCurrent) {
                    this.mappedResources.put(prefix + "_" + resource.getResource().getLocalName(), resource);
                } else {
                    String currentPrefix = this.model.getNsURIPrefix(existingNamespace);
                    this.mappedResources.put(currentPrefix + "_" + existingResource.getResource().getLocalName(), existingResource);
                    this.mappedResources.put(resource.getResource().getLocalName(), resource);
                }
            }
        }
    }

    public String getName(Resource resource) {
        if (resource.isAnon()) {
            return "@blank";
        }
        if (resource.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
            return "type";
        }
        TypedResource mappedResource = (TypedResource)this.mappedResources.get(resource.getLocalName());
        if (mappedResource != null && mappedResource.getResource().equals(resource)) {
            return resource.getLocalName();
        }
        String prefix = this.getPrefixForResourceUri(resource);
        if (prefix != null) {
            return prefix + "_" + resource.getLocalName();
        }
        return resource.getURI();
    }

    public String getPrefixedName(Resource resource) {
        if (resource.isAnon()) {
            return "@blank";
        }
        if (resource.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
            return "type";
        }
        if (this.nameOverrides.containsKey(resource.getURI())) {
            return this.nameOverrides.get(resource.getURI());
        }
        String prefix = this.getPrefixForResourceUri(resource);
        if (prefix != null) {
            return prefix + ":" + resource.getLocalName();
        }
        return resource.getURI();
    }

    public String getPrefixForResourceUri(Resource resource) {
        if (resource.getNameSpace().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            return "rdf";
        }
        if (resource.getNameSpace().equals("http://www.w3.org/2002/07/owl#")) {
            return "owl";
        }
        if (this.nameOverrides.containsKey(resource.getURI())) {
            return null;
        }
        return this.model.getNsURIPrefix(resource.getNameSpace());
    }

    public int compareNames(Resource resource, Resource otherResource) {
        TypedResource mappedResource = (TypedResource)this.mappedResources.get(resource.getLocalName());
        TypedResource otherMappedResource = (TypedResource)this.mappedResources.get(otherResource.getLocalName());
        if (mappedResource == null && otherMappedResource != null) {
            return -1;
        }
        if (mappedResource != null && otherMappedResource == null) {
            return 1;
        }
        return this.getName(resource).compareTo(this.getName(otherResource));
    }

    public SortedMap<String, TypedResource> getMappedResources() {
        return this.mappedResources;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ResourceType {
        NONE,
        VOCAB,
        ID;

    }

    protected class TypedResource {
        private final Resource resource;
        private final ResourceType type;

        private TypedResource(Resource resource, ResourceType type) {
            this.resource = resource;
            this.type = type;
        }

        public Resource getResource() {
            return this.resource;
        }

        public ResourceType getType() {
            return this.type;
        }
    }
}

