/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionIsolationNotSupportedException;
import org.datanucleus.management.runtime.StoreManagerRuntime;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.util.Localiser;

public class FederationManager
implements StoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ExecutionContext.class.getClassLoader());
    StoreManager storeManager;
    final OMFContext omfContext;
    final ClassLoaderResolver clr;

    public FederationManager(ClassLoaderResolver clr, OMFContext omfContext) {
        this.omfContext = omfContext;
        this.clr = clr;
        this.initialiseStoreManager(clr);
    }

    public OMFContext getOMFContext() {
        return this.omfContext;
    }

    protected void initialiseStoreManager(ClassLoaderResolver clr) {
        StoreManager srm = null;
        Extension[] exts = this.omfContext.getPluginManager().getExtensionPoint("org.datanucleus.store_manager").getExtensions();
        String storeManagerType = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.storeManagerType");
        if (storeManagerType != null) {
            for (int e = 0; srm == null && e < exts.length; ++e) {
                ConfigurationElement[] confElm = exts[e].getConfigurationElements();
                for (int c = 0; srm == null && c < confElm.length; ++c) {
                    String key = confElm[c].getAttribute("key");
                    if (!key.equalsIgnoreCase(storeManagerType)) continue;
                    Class[] ctrArgTypes = new Class[]{ClassLoaderResolver.class, OMFContext.class};
                    Object[] ctrArgs = new Object[]{clr, this.omfContext};
                    try {
                        srm = (StoreManager)this.omfContext.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "key", storeManagerType, "class-name", ctrArgTypes, ctrArgs);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new NucleusException(t.getMessage(), t).setFatal();
                    }
                    catch (Exception ex) {
                        throw new NucleusException(ex.getMessage(), ex).setFatal();
                    }
                }
            }
            if (srm == null) {
                throw new NucleusUserException(LOCALISER.msg("008004", (Object)storeManagerType)).setFatal();
            }
        }
        if (srm == null) {
            int idx;
            String url = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionURL");
            if (url != null && (idx = url.indexOf(58)) > -1) {
                url = url.substring(0, idx);
            }
            for (int e = 0; srm == null && e < exts.length; ++e) {
                ConfigurationElement[] confElm = exts[e].getConfigurationElements();
                for (int c = 0; srm == null && c < confElm.length; ++c) {
                    String urlKey = confElm[c].getAttribute("url-key");
                    if (url != null && !urlKey.equalsIgnoreCase(url)) continue;
                    Class[] ctrArgTypes = new Class[]{ClassLoaderResolver.class, OMFContext.class};
                    Object[] ctrArgs = new Object[]{clr, this.omfContext};
                    try {
                        srm = (StoreManager)this.omfContext.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "url-key", url, "class-name", ctrArgTypes, ctrArgs);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new NucleusException(t.getMessage(), t).setFatal();
                    }
                    catch (Exception ex) {
                        throw new NucleusException(ex.getMessage(), ex).setFatal();
                    }
                }
            }
            if (srm == null) {
                throw new NucleusUserException(LOCALISER.msg("008004", (Object)url)).setFatal();
            }
        }
        this.processTransactionIsolation(srm);
    }

    protected void processTransactionIsolation(StoreManager srm) {
        Collection srmOptions;
        String transactionIsolation = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.transactionIsolation");
        if (transactionIsolation != null && !(srmOptions = srm.getSupportedOptions()).contains("TransactionIsolationLevel." + transactionIsolation)) {
            if (transactionIsolation.equals("read-uncommitted")) {
                if (srmOptions.contains("TransactionIsolationLevel.read-committed")) {
                    transactionIsolation = "read-committed";
                } else if (srmOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    transactionIsolation = "serializable";
                } else if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    transactionIsolation = "repeatable-read";
                }
            } else if (transactionIsolation.equals("read-committed")) {
                if (srmOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    transactionIsolation = "repeatable-read";
                } else if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    transactionIsolation = "serializable";
                }
            } else if (transactionIsolation.equals("repeatable-read")) {
                if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    transactionIsolation = "serializable";
                }
            } else {
                throw new TransactionIsolationNotSupportedException(transactionIsolation);
            }
        }
    }

    public StoreManager getStoreManager() {
        return this.storeManager;
    }

    public void close() {
        this.storeManager.close();
    }

    public void addClass(String className, ClassLoaderResolver clr) {
        this.storeManager.addClass(className, clr);
    }

    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        this.storeManager.addClasses(classNames, clr);
    }

    public ApiAdapter getApiAdapter() {
        return this.storeManager.getApiAdapter();
    }

    public Store getBackingStoreForField(ClassLoaderResolver clr, AbstractMemberMetaData fmd, Class type) {
        return this.storeManager.getBackingStoreForField(clr, fmd, type);
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        return this.storeManager.getClassNameForObjectID(id, clr, ec);
    }

    public Date getDatastoreDate() {
        return this.storeManager.getDatastoreDate();
    }

    public Extent getExtent(ExecutionContext ec, Class c, boolean subclasses) {
        return this.storeManager.getExtent(ec, c, subclasses);
    }

    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        return this.storeManager.getNucleusConnection(ec);
    }

    public NucleusSequence getNucleusSequence(ExecutionContext ec, SequenceMetaData seqmd) {
        return this.storeManager.getNucleusSequence(ec, seqmd);
    }

    public StoreSchemaHandler getSchemaHandler() {
        return this.storeManager.getSchemaHandler();
    }

    public StorePersistenceHandler getPersistenceHandler() {
        return this.storeManager.getPersistenceHandler();
    }

    public ValueGenerationManager getValueGenerationManager() {
        return this.storeManager.getValueGenerationManager();
    }

    public StoreManagerRuntime getRuntimeManager() {
        return this.storeManager.getRuntimeManager();
    }

    public String getStoreManagerKey() {
        return this.storeManager.getStoreManagerKey();
    }

    public String getQueryCacheKey() {
        return this.storeManager.getQueryCacheKey();
    }

    public Object getStrategyValue(ExecutionContext ec, AbstractClassMetaData cmd, int absoluteFieldNumber) {
        return this.storeManager.getStrategyValue(ec, cmd, absoluteFieldNumber);
    }

    public HashSet getSubClassesForClass(String className, boolean includeDescendents, ClassLoaderResolver clr) {
        return this.storeManager.getSubClassesForClass(className, includeDescendents, clr);
    }

    public boolean isStrategyDatastoreAttributed(IdentityStrategy identityStrategy, boolean datastoreIdentityField) {
        return this.storeManager.isStrategyDatastoreAttributed(identityStrategy, datastoreIdentityField);
    }

    public String manageClassForIdentity(Object id, ClassLoaderResolver clr) {
        return this.storeManager.manageClassForIdentity(id, clr);
    }

    public boolean managesClass(String className) {
        return this.storeManager.managesClass(className);
    }

    public void notifyObjectIsOutdated(ObjectProvider sm) {
        this.storeManager.notifyObjectIsOutdated(sm);
    }

    public void printInformation(String category, PrintStream ps) throws Exception {
        this.storeManager.printInformation(category, ps);
    }

    public void performVersionCheck(ObjectProvider sm, Object versionDatastore, VersionMetaData versionMetaData) {
        this.storeManager.performVersionCheck(sm, versionDatastore, versionMetaData);
    }

    public void removeAllClasses(ClassLoaderResolver clr) {
        this.storeManager.removeAllClasses(clr);
    }

    public boolean supportsQueryLanguage(String language) {
        return this.storeManager.supportsQueryLanguage(language);
    }

    public boolean supportsValueStrategy(String language) {
        return this.storeManager.supportsValueStrategy(language);
    }

    public Collection getSupportedOptions() {
        return this.storeManager.getSupportedOptions();
    }

    public ConnectionManager getConnectionManager() {
        return this.storeManager.getConnectionManager();
    }

    public ManagedConnection getConnection(ExecutionContext ec) {
        return this.storeManager.getConnection(ec);
    }

    public ManagedConnection getConnection(ExecutionContext ec, Map options) {
        return this.storeManager.getConnection(ec, options);
    }

    public String getConnectionDriverName() {
        return this.storeManager.getConnectionDriverName();
    }

    public String getConnectionURL() {
        return this.storeManager.getConnectionURL();
    }

    public String getConnectionUserName() {
        return this.storeManager.getConnectionUserName();
    }

    public String getConnectionPassword() {
        return this.storeManager.getConnectionPassword();
    }

    public Object getConnectionFactory() {
        return this.storeManager.getConnectionFactory();
    }

    public Object getConnectionFactory2() {
        return this.storeManager.getConnectionFactory2();
    }

    public String getConnectionFactory2Name() {
        return this.storeManager.getConnectionFactory2Name();
    }

    public String getConnectionFactoryName() {
        return this.storeManager.getConnectionFactoryName();
    }

    public void transactionStarted(ExecutionContext ec) {
    }

    public void transactionCommitted(ExecutionContext ec) {
    }

    public void transactionRolledBack(ExecutionContext ec) {
    }
}

