/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;

public class ContainerMetaData
extends MetaData {
    Boolean allowNulls = null;

    public void populate(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr) {
        if (this.parent != null && this.parent.hasExtension("allow-nulls")) {
            if (this.parent.getValueForExtension("allow-nulls").equalsIgnoreCase("true")) {
                this.allowNulls = Boolean.TRUE;
            } else if (this.parent.getValueForExtension("allow-nulls").equalsIgnoreCase("false")) {
                this.allowNulls = Boolean.FALSE;
            }
        }
        if (this.allowNulls == null) {
            Class type = ((AbstractMemberMetaData)this.parent).getType();
            if (type.isArray()) {
                this.allowNulls = type.getComponentType().isPrimitive() ? Boolean.FALSE : Boolean.TRUE;
            } else if (type == HashMap.class) {
                this.allowNulls = Boolean.TRUE;
            } else if (type == Hashtable.class) {
                this.allowNulls = Boolean.FALSE;
            } else if (type == HashSet.class) {
                this.allowNulls = Boolean.TRUE;
            } else if (type == LinkedHashSet.class) {
                this.allowNulls = Boolean.TRUE;
            } else if (List.class.isAssignableFrom(type)) {
                this.allowNulls = Boolean.TRUE;
            }
        }
    }

    public Boolean allowNulls() {
        return this.allowNulls;
    }

    public AbstractMemberMetaData getMemberMetaData() {
        if (this.parent != null) {
            return (AbstractMemberMetaData)this.parent;
        }
        return null;
    }

    public String getFieldName() {
        if (this.parent != null) {
            return ((AbstractMemberMetaData)this.parent).getName();
        }
        return null;
    }
}

