/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.generate.util;

import commonj.sdo.Type;
import java.util.Iterator;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.impl.ModelFactoryImpl;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenDelegationKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenFeatureImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.Literals;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;

public class SDOGenUtil {
    public static String getQualifiedTypeAccessor(GenClassifier genClassifier) {
        GenPackage genPackage = genClassifier.getGenPackage();
        return SDOGenUtil.getFactoryImpl(genPackage) + ".get" + genClassifier.getClassifierAccessorName() + "()";
    }

    public static String getDependentFactoryArgumentList(GenPackage genPackage, boolean isFormalArguments) {
        StringBuffer result = new StringBuffer();
        Iterator iter = genPackage.getPackageInitializationDependencies().iterator();
        while (iter.hasNext()) {
            GenPackage dep = (GenPackage)iter.next();
            if (isFormalArguments) {
                result.append(dep.getImportedFactoryClassName());
                result.append(" ");
            }
            result.append(genPackage.getPackageInstanceVariable(dep));
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String getFactoryImpl(GenPackage genPackage) {
        return "((" + genPackage.getImportedFactoryClassName() + ")" + genPackage.getImportedFactoryInterfaceName() + ".INSTANCE)";
    }

    public static String getListKind(GenFeature genFeature, boolean suppressNotification) {
        boolean unsettable = genFeature.isUnsettable();
        if (suppressNotification) {
            return "ListKind.BASIC";
        }
        if (genFeature.isEffectiveContains()) {
            if (genFeature.isBidirectional()) {
                if (genFeature.isResolveProxies()) {
                    if (unsettable) {
                        return "ListKind.CONTAINMENT_INVERSE_RESOLVING_UNSETTABLE";
                    }
                    return "ListKind.CONTAINMENT_INVERSE_RESOLVING";
                }
                if (unsettable) {
                    return "ListKind.CONTAINMENT_INVERSE_UNSETTABLE";
                }
                return "ListKind.CONTAINMENT_INVERSE";
            }
            if (genFeature.isResolveProxies()) {
                if (unsettable) {
                    return "ListKind.CONTAINMENT_RESOLVING_UNSETTABLE";
                }
                return "ListKind.CONTAINMENT_RESOLVING";
            }
            if (unsettable) {
                return "ListKind.CONTAINMENT_UNSETTABLE";
            }
            return "ListKind.CONTAINMENT";
        }
        if (genFeature.isReferenceType()) {
            if (genFeature.isBidirectional()) {
                GenFeature reverseFeature = genFeature.getReverse();
                if (genFeature.isResolveProxies()) {
                    if (reverseFeature.isListType()) {
                        if (unsettable) {
                            return "ListKind.NONCONTAINMENT_MANYINVERSE_RESOLVING_UNSETTABLE";
                        }
                        return "ListKind.NONCONTAINMENT_MANYINVERSE_RESOLVING";
                    }
                    if (unsettable) {
                        return "ListKind.NONCONTAINMENT_INVERSE_RESOLVING_UNSETTABLE";
                    }
                    return "ListKind.NONCONTAINMENT_INVERSE_RESOLVING";
                }
                if (reverseFeature.isListType()) {
                    if (unsettable) {
                        return "ListKind.NONCONTAINMENT_MANYINVERSE_UNSETTABLE";
                    }
                    return "ListKind.NONCONTAINMENT_MANYINVERSE";
                }
                if (unsettable) {
                    return "ListKind.NONCONTAINMENT_INVERSE_UNSETTABLE";
                }
                return "ListKind.NONCONTAINMENT_INVERSE";
            }
            if (genFeature.isResolveProxies()) {
                if (unsettable) {
                    return "ListKind.NONCONTAINMENT_RESOLVING_UNSETTABLE";
                }
                return "ListKind.NONCONTAINMENT_RESOLVING";
            }
            if (unsettable) {
                return "ListKind.NONCONTAINMENT_UNSETTABLE";
            }
            return "ListKind.NONCONTAINMENT";
        }
        if (genFeature.isUnique()) {
            if (unsettable) {
                return "ListKind.DATATYPE_UNIQUE_UNSETTABLE";
            }
            return "ListKind.DATATYPE_UNIQUE";
        }
        if (unsettable) {
            return "ListKind.DATATYPE_UNSETTABLE";
        }
        return "ListKind.DATATYPE";
    }

    public static boolean hasChangeSummaryProperty(GenClass genClass) {
        return SDOGenUtil.getChangeSummaryProperty(genClass) != null;
    }

    public static String getQualifiedInternalPropertyID(GenFeature genFeature) {
        return genFeature.getGenClass().getImportedClassName() + ".INTERNAL_" + genFeature.getUpperName();
    }

    public static String getChangeSummaryProperty(GenClass genClass) {
        Type csType = ((ModelFactoryImpl)ModelFactory.INSTANCE).getChangeSummaryType();
        Iterator i = genClass.getGenFeatures().iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            EClassifier eClassifier = genFeature.getEcoreFeature().getEType();
            if (!(eClassifier instanceof Type)) continue;
            Type type = (Type)eClassifier;
            if (!csType.getName().equals(type.getName()) || !csType.getURI().equals(type.getURI())) continue;
            return genFeature.getUpperName();
        }
        return null;
    }

    public static String printArguments(GenPackage genPackage, GenModel genModel) {
        StringBuffer result = new StringBuffer();
        if (!CodeGenUtil.capName((String)genPackage.getNSName()).equals(genPackage.getPrefix())) {
            result.append(" -prefix " + genPackage.getPrefix());
        }
        if (genModel.isSuppressInterfaces()) {
            result.append(" -noInterfaces");
        }
        if (genModel.getFeatureDelegation() == GenDelegationKind.VIRTUAL_LITERAL) {
            result.append(" -sparsePattern");
        }
        if ("org.apache.tuscany.sdo.impl.StoreDataObjectImpl".equals(genModel.getRootExtendsClass())) {
            result.append(" -storePattern");
        }
        if (genModel.isSuppressNotification()) {
            result.append(" -noNotification");
        }
        if (genModel.isSuppressContainment()) {
            result.append(" -noContainment");
        }
        if (genModel.isArrayAccessors()) {
            result.append(" -arrayAccessors");
        }
        if (genModel.isSuppressUnsettable()) {
            result.append(" -noUnsettable");
        }
        return result.toString();
    }

    public static String getStaticDefaultValue(GenFeature genFeature) {
        String result = "null";
        boolean defaultFound = false;
        String defaultString = genFeature.getEcoreFeature().getDefaultValueLiteral();
        EClassifier eType = genFeature.getEcoreFeature().getEType();
        if (eType instanceof EDataType) {
            EDataType eDataType;
            GenPackage genPackage = ((GenFeatureImpl)genFeature).findGenPackage(genFeature.getEcoreFeature().getEType().getEPackage());
            GenDataType gdt = null;
            if (genPackage != null) {
                Iterator iter = genPackage.getGenDataTypes().iterator();
                while (iter.hasNext() && gdt == null) {
                    GenDataType genDataType = (GenDataType)iter.next();
                    if (!eType.getName().equals(genDataType.getEcoreDataType().getName())) continue;
                    gdt = genDataType;
                }
            }
            if ((eDataType = gdt.getEcoreDataType()).getEPackage() != EcorePackage.eINSTANCE && defaultString != null) {
                boolean replaced = false;
                Iterator i = EcorePackage.eINSTANCE.getEClassifiers().iterator();
                while (i.hasNext()) {
                    EClassifier eClassifier = (EClassifier)i.next();
                    if (!(eClassifier instanceof EDataType) || !eClassifier.getInstanceClassName().equals(eDataType.getInstanceClassName()) || !((EDataType)eClassifier).isSerializable() || eClassifier == EcorePackage.eINSTANCE.getEDate()) continue;
                    replaced = true;
                    eDataType = eClassifier;
                    break;
                }
                if (!replaced) {
                    result = "((" + genPackage.getFactoryClassName() + ")" + genPackage.getFactoryInterfaceName() + "." + genPackage.getFactoryInstanceName() + ")." + "create" + gdt.getName() + "FromString(" + Literals.toLiteral((Object)defaultString) + ")";
                    if (gdt.isPrimitiveType()) {
                        result = "((" + gdt.getObjectInstanceClassName() + ")" + result + ")." + gdt.getPrimitiveValueFunction() + "()";
                    } else if (!gdt.isObjectType()) {
                        result = "(" + gdt.getImportedInstanceClassName() + ")" + result;
                    }
                    defaultFound = true;
                }
            }
        }
        if (!defaultFound) {
            result = genFeature.getStaticDefaultValue();
        }
        return result;
    }
}

