/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util.metadata.impl;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import org.apache.tuscany.sdo.SDOFactory;
import org.apache.tuscany.sdo.impl.FactoryBase;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.impl.ModelFactoryImpl;
import org.apache.tuscany.sdo.util.SDOUtil;
import org.apache.tuscany.sdo.util.metadata.JavaMetaData;
import org.apache.tuscany.sdo.util.metadata.MetadataFactory;
import org.apache.tuscany.sdo.util.metadata.SDOMetaDataGroup;
import org.apache.tuscany.sdo.util.metadata.TypeMetaData;
import org.apache.tuscany.sdo.util.metadata.XSDMetaData;
import org.apache.tuscany.sdo.util.metadata.impl.JavaMetaDataImpl;
import org.apache.tuscany.sdo.util.metadata.impl.SDOMetaDataGroupImpl;
import org.apache.tuscany.sdo.util.metadata.impl.TypeMetaDataImpl;
import org.apache.tuscany.sdo.util.metadata.impl.XSDMetaDataImpl;

public class MetadataFactoryImpl
extends FactoryBase
implements MetadataFactory {
    public static final String NAMESPACE_URI = "org.apache.tuscany.sdo/metadata";
    public static final String NAMESPACE_PREFIX = "metadata";
    public static final int JAVA_META_DATA = 1;
    public static final int SDO_META_DATA_GROUP = 2;
    public static final int TYPE_META_DATA = 3;
    public static final int XSD_META_DATA = 4;
    protected Type javaMetaDataType = null;
    protected Type sdoMetaDataGroupType = null;
    protected Type typeMetaDataType = null;
    protected Type xsdMetaDataType = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    public MetadataFactoryImpl() {
        super(NAMESPACE_URI, NAMESPACE_PREFIX);
    }

    public DataObject create(int typeNumber) {
        switch (typeNumber) {
            case 1: {
                return (DataObject)this.createJavaMetaData();
            }
            case 2: {
                return (DataObject)this.createSDOMetaDataGroup();
            }
            case 3: {
                return (DataObject)this.createTypeMetaData();
            }
            case 4: {
                return (DataObject)this.createXSDMetaData();
            }
        }
        return super.create(typeNumber);
    }

    public JavaMetaData createJavaMetaData() {
        JavaMetaDataImpl javaMetaData = new JavaMetaDataImpl();
        return javaMetaData;
    }

    public SDOMetaDataGroup createSDOMetaDataGroup() {
        SDOMetaDataGroupImpl sdoMetaDataGroup = new SDOMetaDataGroupImpl();
        return sdoMetaDataGroup;
    }

    public TypeMetaData createTypeMetaData() {
        TypeMetaDataImpl typeMetaData = new TypeMetaDataImpl();
        return typeMetaData;
    }

    public XSDMetaData createXSDMetaData() {
        XSDMetaDataImpl xsdMetaData = new XSDMetaDataImpl();
        return xsdMetaData;
    }

    public Type getJavaMetaData() {
        return this.javaMetaDataType;
    }

    public Type getSDOMetaDataGroup() {
        return this.sdoMetaDataGroupType;
    }

    public Type getTypeMetaData() {
        return this.typeMetaDataType;
    }

    public Type getXSDMetaData() {
        return this.xsdMetaDataType;
    }

    public static MetadataFactoryImpl init() {
        if (isInited) {
            return (MetadataFactoryImpl)FactoryBase.getStaticFactory(NAMESPACE_URI);
        }
        MetadataFactoryImpl theMetadataFactoryImpl = new MetadataFactoryImpl();
        isInited = true;
        SDOUtil.registerStaticTypes(SDOFactory.class);
        SDOUtil.registerStaticTypes(ModelFactory.class);
        theMetadataFactoryImpl.createMetaData();
        theMetadataFactoryImpl.initializeMetaData();
        return theMetadataFactoryImpl;
    }

    public void createMetaData() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.javaMetaDataType = this.createType(false, 1);
        this.createProperty(true, this.javaMetaDataType, 0);
        this.createProperty(true, this.javaMetaDataType, 1);
        this.sdoMetaDataGroupType = this.createType(false, 2);
        this.createProperty(false, this.sdoMetaDataGroupType, 0);
        this.createProperty(false, this.sdoMetaDataGroupType, 1);
        this.createProperty(false, this.sdoMetaDataGroupType, 2);
        this.typeMetaDataType = this.createType(false, 3);
        this.createProperty(true, this.typeMetaDataType, 0);
        this.xsdMetaDataType = this.createType(false, 4);
        this.createProperty(true, this.xsdMetaDataType, 0);
    }

    public void initializeMetaData() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        ModelFactoryImpl theModelPackageImpl = (ModelFactoryImpl)FactoryBase.getStaticFactory("commonj.sdo");
        Property property = null;
        this.initializeType(this.javaMetaDataType, JavaMetaData.class, "JavaMetaData");
        property = (Property)this.javaMetaDataType.getProperties().get(0);
        this.initializeProperty(property, theModelPackageImpl.getString(), "factoryInterface", null, 0, 1, JavaMetaData.class, false, false, false);
        property = (Property)this.javaMetaDataType.getProperties().get(1);
        this.initializeProperty(property, theModelPackageImpl.getString(), "typeInterface", null, 0, 1, JavaMetaData.class, false, false, false);
        this.initializeType(this.sdoMetaDataGroupType, SDOMetaDataGroup.class, "SDOMetaDataGroup");
        property = (Property)this.sdoMetaDataGroupType.getProperties().get(0);
        this.initializeProperty(property, this.getJavaMetaData(), "javaMetaData", null, 0, -1, SDOMetaDataGroup.class, false, false, false, true, null);
        property = (Property)this.sdoMetaDataGroupType.getProperties().get(1);
        this.initializeProperty(property, this.getXSDMetaData(), "xsdMetaData", null, 0, -1, SDOMetaDataGroup.class, false, false, false, true, null);
        property = (Property)this.sdoMetaDataGroupType.getProperties().get(2);
        this.initializeProperty(property, this.getTypeMetaData(), "typeMetaData", null, 0, -1, SDOMetaDataGroup.class, false, false, false, true, null);
        this.initializeType(this.typeMetaDataType, TypeMetaData.class, "TypeMetaData");
        property = (Property)this.typeMetaDataType.getProperties().get(0);
        this.initializeProperty(property, theModelPackageImpl.getString(), "location", null, 1, 1, TypeMetaData.class, false, false, false);
        this.initializeType(this.xsdMetaDataType, XSDMetaData.class, "XSDMetaData");
        property = (Property)this.xsdMetaDataType.getProperties().get(0);
        this.initializeProperty(property, theModelPackageImpl.getString(), "location", null, 1, 1, XSDMetaData.class, false, false, false);
        this.createXSDMetaData(theModelPackageImpl);
    }

    protected void createXSDMetaData(ModelFactoryImpl theModelPackageImpl) {
        super.initXSD();
        Property property = null;
        property = this.createGlobalProperty("sdoMetaDataGroup", this.getSDOMetaDataGroup(), new String[]{"kind", "element", "name", "sdoMetaDataGroup", "namespace", "##targetNamespace"});
        this.addXSDMapping(this.javaMetaDataType, new String[]{"name", "JavaMetaData", "kind", "empty"});
        this.addXSDMapping((Property)this.javaMetaDataType.getProperties().get(0), new String[]{"kind", "attribute", "name", "factoryInterface"});
        this.addXSDMapping((Property)this.javaMetaDataType.getProperties().get(1), new String[]{"kind", "attribute", "name", "typeInterface"});
        this.addXSDMapping(this.sdoMetaDataGroupType, new String[]{"name", "SDOMetaDataGroup", "kind", "elementOnly"});
        this.addXSDMapping((Property)this.sdoMetaDataGroupType.getProperties().get(0), new String[]{"kind", "element", "name", "javaMetaData"});
        this.addXSDMapping((Property)this.sdoMetaDataGroupType.getProperties().get(1), new String[]{"kind", "element", "name", "xsdMetaData"});
        this.addXSDMapping((Property)this.sdoMetaDataGroupType.getProperties().get(2), new String[]{"kind", "element", "name", "typeMetaData"});
        this.addXSDMapping(this.typeMetaDataType, new String[]{"name", "TypeMetaData", "kind", "empty"});
        this.addXSDMapping((Property)this.typeMetaDataType.getProperties().get(0), new String[]{"kind", "attribute", "name", "location"});
        this.addXSDMapping(this.xsdMetaDataType, new String[]{"name", "XSDMetaData", "kind", "empty"});
        this.addXSDMapping((Property)this.xsdMetaDataType.getProperties().get(0), new String[]{"kind", "attribute", "name", "location"});
    }
}

