/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XMLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.XMLDocumentImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.xml.sax.InputSource;

public class XMLHelperImpl
implements XMLHelper {
    protected HelperContext helperContext;
    private ExtendedMetaData extendedMetaData;

    public XMLHelperImpl(HelperContext hc) {
        this.helperContext = hc;
        this.extendedMetaData = ((HelperContextImpl)hc).extendedMetaData;
    }

    public XMLDocument load(String inputString) {
        try {
            return this.load(new StringReader(inputString), null, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XMLDocument load(String inputString, Object options) {
        try {
            return this.load(new StringReader(inputString), null, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XMLDocument load(InputStream inputStream) throws IOException {
        return this.load(inputStream, null, null);
    }

    private Object checkSetOptions(Object options) throws IOException {
        if (options != null && !(options instanceof Map)) {
            throw new IOException("Invalid load options!");
        }
        if (this.helperContext != null) {
            return ((HelperContextImpl)this.helperContext).getMergedOption((Map)options);
        }
        return options;
    }

    public XMLDocument load(InputStream inputStream, String locationURI, Object options) throws IOException {
        options = this.checkSetOptions(options);
        XMLDocumentImpl document = new XMLDocumentImpl(this.extendedMetaData, options);
        document.load(inputStream, locationURI, options);
        return document;
    }

    public XMLDocument load(Reader inputReader, String locationURI, Object options) throws IOException {
        XMLDocumentImpl document = new XMLDocumentImpl(this.extendedMetaData, options);
        options = this.checkSetOptions(options);
        document.load(inputReader, locationURI, options);
        return document;
    }

    public XMLDocument load(Source source, String locationURI, Object options) throws IOException {
        options = this.checkSetOptions(options);
        if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            XMLDocumentImpl document = new XMLDocumentImpl(this.extendedMetaData, options);
            document.load(domSource.getNode(), options);
            return document;
        }
        if (source instanceof SAXSource) {
            XMLDocumentImpl document = new XMLDocumentImpl(this.extendedMetaData, options);
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            document.load(inputSource, locationURI, options);
            return document;
        }
        if (source instanceof StreamSource) {
            return this.load(((StreamSource)source).getInputStream(), locationURI, options);
        }
        throw new UnsupportedOperationException();
    }

    public String save(DataObject dataObject, String rootElementURI, String rootElementName) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.save(this.createDocument(dataObject, rootElementURI, rootElementName), stringWriter, null);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String save(DataObject dataObject, String rootElementURI, String rootElementName, Object options) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.save(this.createDocument(dataObject, rootElementURI, rootElementName), stringWriter, options);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(DataObject dataObject, String rootElementURI, String rootElementName, OutputStream outputStream) throws IOException {
        this.save(this.createDocument(dataObject, rootElementURI, rootElementName), outputStream, null);
    }

    public void save(DataObject dataObject, String rootElementURI, String rootElementName, OutputStream outputStream, Object options) throws IOException {
        this.save(this.createDocument(dataObject, rootElementURI, rootElementName), outputStream, null);
    }

    public void save(XMLDocument xmlDocument, OutputStream outputStream, Object options) throws IOException {
        options = this.checkSetOptions(options);
        ((XMLDocumentImpl)xmlDocument).save(outputStream, options);
    }

    public void save(XMLDocument xmlDocument, Writer outputWriter, Object options) throws IOException {
        options = this.checkSetOptions(options);
        ((XMLDocumentImpl)xmlDocument).save(outputWriter, options);
    }

    public void save(XMLDocument xmlDocument, Result outputResult, Object options) throws IOException {
        options = this.checkSetOptions(options);
        if (outputResult instanceof DOMResult) {
            ((XMLDocumentImpl)xmlDocument).save(((DOMResult)outputResult).getNode(), options);
        } else {
            if (outputResult instanceof SAXResult) {
                throw new UnsupportedOperationException();
            }
            if (outputResult instanceof StreamResult) {
                this.save(xmlDocument, ((StreamResult)outputResult).getOutputStream(), options);
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    public XMLDocument createDocument(DataObject dataObject, String rootElementURI, String rootElementName) {
        XMLDocumentImpl xmlDocument = new XMLDocumentImpl(this.extendedMetaData, dataObject, rootElementURI, rootElementName);
        xmlDocument.setEncoding("UTF-8");
        return xmlDocument;
    }

    public HelperContext getHelperContext() {
        return this.helperContext;
    }
}

