/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.impl.HelperProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sdo.SDOExtendedMetaData;
import org.apache.tuscany.sdo.SDOFactory;
import org.apache.tuscany.sdo.SimpleAnyTypeDataObject;
import org.apache.tuscany.sdo.api.EventListener;
import org.apache.tuscany.sdo.api.SDOHelper;
import org.apache.tuscany.sdo.api.XMLStreamHelper;
import org.apache.tuscany.sdo.helper.CrossScopeCopyHelperImpl;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.impl.ClassImpl;
import org.apache.tuscany.sdo.impl.DataGraphImpl;
import org.apache.tuscany.sdo.impl.DynamicDataObjectImpl;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.impl.ModelFactoryImpl;
import org.apache.tuscany.sdo.spi.SDOHelperBase;
import org.apache.tuscany.sdo.util.DataObjectUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class SDOHelperImpl
extends SDOHelperBase
implements SDOHelper,
SDOHelper.MetaDataBuilder {
    static final Object LOADING_SCOPE = "EXTENDED_META_DATA";

    public DataObject createDataTypeWrapper(Type dataType, Object value) {
        SimpleAnyTypeDataObject simpleAnyType = SDOFactory.eINSTANCE.createSimpleAnyTypeDataObject();
        simpleAnyType.setInstanceType((EDataType)dataType);
        simpleAnyType.setValue(value);
        return simpleAnyType;
    }

    public Object createFromString(Type dataType, String literal) {
        return EcoreUtil.createFromString((EDataType)((EDataType)dataType), (String)literal);
    }

    public String convertToString(Type dataType, Object value) {
        return EcoreUtil.convertToString((EDataType)((EDataType)dataType), (Object)value);
    }

    public Type getXSDSDOType(String xsdType) {
        Type type = null;
        String name = (String)xsdToSdoMappings.get(xsdType);
        if (name != null) {
            type = (Type)((ModelFactoryImpl)ModelFactory.INSTANCE).getEClassifier(name);
        }
        return type;
    }

    public Sequence getSubstitutionValues(DataObject dataObject, Property head) {
        EStructuralFeature group = ExtendedMetaData.INSTANCE.getGroup((EStructuralFeature)head);
        return null == group ? null : (Sequence)((FeatureMap.Internal)((EObject)dataObject).eGet(group)).getWrapper();
    }

    public Type getJavaSDOType(Class javaClass) {
        String name = (String)javaToSdoMappings.get(javaClass);
        if (name != null) {
            return (Type)((ModelFactoryImpl)ModelFactory.INSTANCE).getEClassifier(name);
        }
        return null;
    }

    public boolean isRequired(Property property) {
        return ((EStructuralFeature)property).isRequired();
    }

    public int getUpperBound(Property property) {
        return ((EStructuralFeature)property).getUpperBound();
    }

    public int getLowerBound(Property property) {
        return ((EStructuralFeature)property).getLowerBound();
    }

    public List getEnumerationFacet(Type type) {
        List instProps = type.getInstanceProperties();
        String propertyName = "enumeration";
        Property enumProperty = null;
        for (int i = 0; i < instProps.size(); ++i) {
            Property prop = (Property)instProps.get(i);
            if (!propertyName.equals(prop.getName())) continue;
            enumProperty = prop;
        }
        return (List)DataObjectUtil.getMetaObjectInstanceProperty((EModelElement)type, enumProperty);
    }

    public List getPatternFacet(Type type) {
        List instProps = type.getInstanceProperties();
        String propertyName = "pattern";
        Property patternProperty = null;
        for (int i = 0; i < instProps.size(); ++i) {
            Property prop = (Property)instProps.get(i);
            if (!propertyName.equals(prop.getName())) continue;
            patternProperty = prop;
        }
        return (List)DataObjectUtil.getMetaObjectInstanceProperty((EModelElement)type, patternProperty);
    }

    public boolean isMany(Property property, DataObject context) {
        return FeatureMapUtil.isMany((EObject)((EObject)context), (EStructuralFeature)((EStructuralFeature)property));
    }

    public DataGraph createDataGraph() {
        return SDOFactory.eINSTANCE.createDataGraph();
    }

    public void setRootObject(DataGraph dataGraph, DataObject rootObject) {
        ((DataGraphImpl)dataGraph).setERootObject((EObject)rootObject);
    }

    public static DataGraph loadDataGraph(InputStream inputStream, Map options) throws IOException {
        ResourceSet resourceSet = DataObjectUtil.createResourceSet();
        Resource resource = resourceSet.createResource(URI.createURI((String)"all.datagraph"));
        resource.load(inputStream, options);
        return (DataGraph)resource.getContents().get(0);
    }

    protected void registerLoadingScope(Map options, TypeHelper scope) {
        ExtendedMetaData extendedMetaData = ((TypeHelperImpl)scope).getExtendedMetaData();
        options.put(LOADING_SCOPE, extendedMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataGraph loadDataGraph(InputStream inputStream, Map options, HelperContext scope) throws IOException {
        if (scope == null) {
            scope = HelperProvider.getDefaultContext();
        }
        TypeHelper th = scope.getTypeHelper();
        DataGraph result = null;
        if (th == null || th == TypeHelper.INSTANCE) {
            result = SDOHelperImpl.loadDataGraph(inputStream, options);
        } else if (options == null) {
            options = new HashMap();
            this.registerLoadingScope(options, th);
            result = SDOHelperImpl.loadDataGraph(inputStream, options);
        } else {
            if (options.containsKey(LOADING_SCOPE)) {
                Object restore = options.get(LOADING_SCOPE);
                this.registerLoadingScope(options, th);
                try {
                    result = SDOHelperImpl.loadDataGraph(inputStream, options);
                }
                finally {
                    options.put(LOADING_SCOPE, restore);
                }
            }
            this.registerLoadingScope(options, th);
            try {
                result = SDOHelperImpl.loadDataGraph(inputStream, options);
            }
            finally {
                options.remove(LOADING_SCOPE);
            }
        }
        return result;
    }

    public void saveDataGraph(DataGraph dataGraph, OutputStream outputStream, Map options) throws IOException {
        ((DataGraphImpl)dataGraph).getDataGraphResource().save(outputStream, options);
    }

    public void registerDataGraphTypes(DataGraph dataGraph, List types) {
        HashSet<EPackage> packages = new HashSet<EPackage>();
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            EClassifier type = (EClassifier)iterator.next();
            packages.add(type.getEPackage());
        }
        ResourceSet resourceSet = ((DataGraphImpl)dataGraph).getResourceSet();
        Iterator iterator2 = packages.iterator();
        while (iterator2.hasNext()) {
            EPackage typePackage = (EPackage)iterator2.next();
            Resource resource = typePackage.eResource();
            if (resource == null) {
                resource = resourceSet.createResource(URI.createURI((String)".ecore"));
                resource.setURI(URI.createURI((String)typePackage.getNsURI()));
                resource.getContents().add((Object)typePackage);
                continue;
            }
            if (resource.getResourceSet() == resourceSet) continue;
            resourceSet.getResources().add((Object)resource);
        }
    }

    public HelperContext createHelperContext() {
        return new HelperContextImpl(false, null);
    }

    public HelperContext createHelperContext(boolean extensibleNamespaces) {
        return new HelperContextImpl(extensibleNamespaces);
    }

    public HelperContext createHelperContext(Map options) {
        return new HelperContextImpl(false, options);
    }

    public HelperContext createHelperContext(boolean extensibleNamespaces, Map options) {
        return new HelperContextImpl(extensibleNamespaces, options);
    }

    public CopyHelper createCrossScopeCopyHelper(HelperContext hc) {
        return new CrossScopeCopyHelperImpl(hc.getTypeHelper());
    }

    public XMLStreamHelper createXMLStreamHelper(HelperContext hc) {
        return ((HelperContextImpl)hc).getXMLStreamHelper();
    }

    public List getTypes(HelperContext hc, String uri) {
        EPackage ePackage = ((HelperContextImpl)hc).getExtendedMetaData().getPackage(uri);
        if (ePackage != null) {
            return new ArrayList(ePackage.getEClassifiers());
        }
        return null;
    }

    public List getOpenContentProperties(DataObject dataObject) {
        UniqueEList result = new UniqueEList();
        ((ClassImpl)dataObject.getType()).addOpenProperties((EObject)dataObject, (Collection)result);
        return result;
    }

    public boolean isDocumentRoot(Type type) {
        return "".equals(SDOExtendedMetaData.INSTANCE.getName((EClassifier)type));
    }

    public Type createType(HelperContext hc, String uri, String name, boolean isDataType) {
        EClassifier eClassifier;
        EPackage ePackage;
        ExtendedMetaData extendedMetaData = ((HelperContextImpl)hc).getExtendedMetaData();
        if ("".equals(uri)) {
            uri = null;
        }
        if ((ePackage = extendedMetaData.getPackage(uri)) == null) {
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            ePackage.setEFactoryInstance((EFactory)new DynamicDataObjectImpl.FactoryImpl());
            ePackage.setNsURI(uri);
            String packagePrefix = uri != null ? URI.createURI((String)uri).trimFileExtension().lastSegment() : "";
            ePackage.setName(packagePrefix);
            ePackage.setNsPrefix(packagePrefix);
            extendedMetaData.putPackage(uri, ePackage);
        }
        if ((eClassifier = ePackage.getEClassifier(name)) != null) {
            return null;
        }
        if (name != null) {
            eClassifier = isDataType ? (EClassifier)SDOFactory.eINSTANCE.createDataType() : (EClassifier)SDOFactory.eINSTANCE.createClass();
            eClassifier.setName(name);
        } else {
            eClassifier = DataObjectUtil.createDocumentRoot();
        }
        ePackage.getEClassifiers().add((Object)eClassifier);
        return (Type)eClassifier;
    }

    public void addBaseType(Type type, Type baseType) {
        ((EClass)type).getESuperTypes().add((Object)baseType);
    }

    public void addAliasName(Type type, String aliasName) {
        throw new UnsupportedOperationException();
    }

    public void setOpen(Type type, boolean isOpen) {
        if (isOpen == type.isOpen()) {
            return;
        }
        if (isOpen) {
            EAttribute eAttribute = (EAttribute)SDOFactory.eINSTANCE.createAttribute();
            ((EClass)type).getEStructuralFeatures().add((Object)eAttribute);
            eAttribute.setName("any");
            eAttribute.setUnique(false);
            eAttribute.setUpperBound(-1);
            eAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEFeatureMapEntry());
            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eAttribute, 5);
            ExtendedMetaData.INSTANCE.setProcessingKind((EStructuralFeature)eAttribute, 2);
            ExtendedMetaData.INSTANCE.setWildcards((EStructuralFeature)eAttribute, Collections.singletonList("##any"));
            if (ExtendedMetaData.INSTANCE.getMixedFeature((EClass)type) != null) {
                eAttribute.setDerived(true);
                eAttribute.setTransient(true);
                eAttribute.setVolatile(true);
            }
        } else {
            EClass eClass = (EClass)type;
            EAttribute any = (EAttribute)eClass.getEStructuralFeature("any");
            eClass.getEStructuralFeatures().remove((Object)any);
        }
    }

    public void setSequenced(Type type, boolean isSequenced) {
        if ((type.isDataType() || !type.getProperties().isEmpty()) && type.getName() != "DocumentRoot") {
            throw new IllegalArgumentException();
        }
        if (isSequenced) {
            EClass eClass = (EClass)type;
            ExtendedMetaData.INSTANCE.setContentKind(eClass, 3);
            EAttribute mixedFeature = (EAttribute)SDOFactory.eINSTANCE.createAttribute();
            mixedFeature.setName("mixed");
            mixedFeature.setUnique(false);
            mixedFeature.setEType((EClassifier)EcorePackage.eINSTANCE.getEFeatureMapEntry());
            mixedFeature.setLowerBound(0);
            mixedFeature.setUpperBound(-1);
            ((ClassImpl)eClass).setSequenceFeature(mixedFeature);
            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)mixedFeature, 5);
            ExtendedMetaData.INSTANCE.setName((EStructuralFeature)mixedFeature, ":mixed");
        }
    }

    public void setAbstract(Type type, boolean isAbstract) {
        ((EClass)type).setAbstract(isAbstract);
    }

    public void setJavaClassName(Type type, String javaClassName) {
        ((EClassifier)type).setInstanceClassName(javaClassName);
    }

    public Property createProperty(Type containingType, String name, Type propertyType) {
        EStructuralFeature eStructuralFeature = propertyType.isDataType() ? (EStructuralFeature)SDOFactory.eINSTANCE.createAttribute() : (EStructuralFeature)SDOFactory.eINSTANCE.createReference();
        eStructuralFeature.setName(name);
        eStructuralFeature.setEType((EClassifier)propertyType);
        ((EClass)containingType).getEStructuralFeatures().add((Object)eStructuralFeature);
        if ("".equals(ExtendedMetaData.INSTANCE.getName((EClassifier)((EClass)containingType)))) {
            ExtendedMetaData.INSTANCE.setNamespace(eStructuralFeature, containingType.getURI());
        }
        if (ExtendedMetaData.INSTANCE.getMixedFeature((EClass)containingType) != null) {
            eStructuralFeature.setDerived(true);
            eStructuralFeature.setTransient(true);
            eStructuralFeature.setVolatile(true);
            ExtendedMetaData.INSTANCE.setFeatureKind(eStructuralFeature, 4);
        } else {
            ExtendedMetaData.INSTANCE.setFeatureKind(eStructuralFeature, 4);
        }
        return (Property)eStructuralFeature;
    }

    public void setPropertyXMLKind(Property property, boolean isXmlElement) {
        if (isXmlElement) {
            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)property, 4);
        } else {
            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)property, 2);
        }
    }

    public Property createOpenContentProperty(HelperContext hc, String uri, String name, Type type) {
        Property newProperty;
        Type documentRoot;
        ExtendedMetaData extendedMetaData = ((HelperContextImpl)hc).getExtendedMetaData();
        EPackage ePackage = extendedMetaData.getPackage(uri);
        Type type2 = documentRoot = ePackage != null ? (Type)extendedMetaData.getType(ePackage, "") : null;
        if (documentRoot == null) {
            documentRoot = this.createType(hc, uri, null, false);
        }
        if ((newProperty = documentRoot.getProperty(name)) == null) {
            newProperty = this.createProperty(documentRoot, name, type);
        } else if (!newProperty.getType().equals(type)) {
            throw new IllegalArgumentException();
        }
        return newProperty;
    }

    public void addAliasName(Property property, String aliasName) {
        throw new UnsupportedOperationException();
    }

    public void setMany(Property property, boolean isMany) {
        ((EStructuralFeature)property).setUpperBound(isMany ? -1 : 1);
    }

    public void setContainment(Property property, boolean isContainment) {
        ((EReference)property).setContainment(isContainment);
    }

    public void setDefault(Property property, String defaultValue) {
        ((EStructuralFeature)property).setDefaultValueLiteral(defaultValue);
    }

    public void setReadOnly(Property property, boolean isReadOnly) {
        ((EStructuralFeature)property).setChangeable(!isReadOnly);
    }

    public void setOpposite(Property property, Property opposite) {
        ((EReference)property).setEOpposite((EReference)opposite);
    }

    public void addTypeInstanceProperty(Type definedType, Property instanceProperty, Object value) {
        this.addInstanceProperty((EModelElement)definedType, instanceProperty, value);
    }

    public void addPropertyInstanceProperty(Property definedProperty, Property instanceProperty, Object value) {
        this.addInstanceProperty((EModelElement)definedProperty, instanceProperty, value);
    }

    protected void addInstanceProperty(EModelElement metaObject, Property property, Object value) {
        String uri = property.getContainingType().getURI();
        EAnnotation eAnnotation = metaObject.getEAnnotation(uri);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(uri);
            metaObject.getEAnnotations().add((Object)eAnnotation);
        }
        String stringValue = this.convertToString(property.getType(), value);
        eAnnotation.getDetails().put((Object)property.getName(), (Object)stringValue);
    }

    public void addChangeListener(DataObject dob, EventListener listener) {
        ((Notifier)dob).eAdapters().add((Object)listener);
    }

    public void removeChangeListener(DataObject dob, EventListener listener) {
        ((Notifier)dob).eAdapters().remove((Object)listener);
    }
}

