/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.scheduler.simple;

import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.DatabaseException;
import org.apache.ode.scheduler.simple.Job;
import org.apache.ode.utils.DbIsolation;
import org.apache.ode.utils.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDelegate
implements DatabaseDelegate {
    private static final Log __log = LogFactory.getLog(JdbcDelegate.class);
    private static final String DELETE_JOB = "delete from ODE_JOB where jobid = ? and nodeid = ?";
    private static final String UPDATE_REASSIGN = "update ODE_JOB set nodeid = ?, scheduled = 0 where nodeid = ?";
    private static final String UPGRADE_JOB_DEFAULT = "update ODE_JOB set nodeid = ? where nodeid is null and mod(ts,?) = ? and ts < ?";
    private static final String UPGRADE_JOB_DB2 = "update ODE_JOB set nodeid = ? where nodeid is null and mod(ts,CAST(? AS BIGINT)) = ? and ts < ?";
    private static final String UPGRADE_JOB_SQLSERVER = "update ODE_JOB set nodeid = ? where nodeid is null and (ts % ?) = ? and ts < ?";
    private static final String UPGRADE_JOB_SYBASE = "update ODE_JOB set nodeid = ? where nodeid is null and convert(int, ts) % ? = ? and ts < ?";
    private static final String UPGRADE_JOB_SYBASE12 = "update ODE_JOB set nodeid = ? where nodeid is null and -1 <> ? and -1 <> ? and ts < ?";
    private static final String SAVE_JOB = "insert into ODE_JOB  (jobid, nodeid, ts, scheduled, transacted, details) values(?, ?, ?, ?, ?, ?)";
    private static final String GET_NODEIDS = "select distinct nodeid from ODE_JOB";
    private static final String SCHEDULE_IMMEDIATE = "select jobid, ts, transacted, scheduled, details from ODE_JOB where nodeid = ? and ts < ? order by ts";
    private DataSource _ds;
    private Dialect _dialect;

    public JdbcDelegate(DataSource dataSource) {
        this._ds = dataSource;
        this._dialect = this.guessDialect();
    }

    @Override
    public boolean deleteJob(String string, String string2) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("deleteJob " + string + " on node " + string2));
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(DELETE_JOB);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            boolean bl = preparedStatement.executeUpdate() == 1;
            this.close(preparedStatement);
            this.close(connection);
            return bl;
        }
        catch (SQLException sQLException) {
            try {
                throw new DatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                this.close(connection);
                throw throwable;
            }
        }
    }

    @Override
    public List<String> getNodeIds() throws DatabaseException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            Object object;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(GET_NODEIDS, 1003, 1007);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (object == null) continue;
                arrayList.add(resultSet.getString(1));
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("getNodeIds: " + arrayList));
            }
            object = arrayList;
            this.close(preparedStatement);
            this.close(connection);
            return object;
        }
        catch (SQLException sQLException) {
            try {
                throw new DatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                this.close(connection);
                throw throwable;
            }
        }
    }

    @Override
    public boolean insertJob(Job job, String string, boolean bl) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("insertJob " + job.jobId + " on node " + string + " loaded=" + bl));
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(SAVE_JOB);
            preparedStatement.setString(1, job.jobId);
            preparedStatement.setString(2, string);
            preparedStatement.setLong(3, job.schedDate);
            preparedStatement.setInt(4, this.asInteger(bl));
            preparedStatement.setInt(5, this.asInteger(job.transacted));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                StreamUtils.write((OutputStream)byteArrayOutputStream, (Serializable)((Serializable)((Object)job.detail)));
            }
            catch (Exception exception) {
                __log.error((Object)("Error serializing job detail: " + job.detail));
                throw new DatabaseException(exception);
            }
            preparedStatement.setBytes(6, byteArrayOutputStream.toByteArray());
            boolean bl2 = preparedStatement.executeUpdate() == 1;
            this.close(preparedStatement);
            this.close(connection);
            return bl2;
        }
        catch (SQLException sQLException) {
            try {
                throw new DatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                this.close(connection);
                throw throwable;
            }
        }
    }

    @Override
    public List<Job> dequeueImmediate(String string, long l, int n) throws DatabaseException {
        ArrayList<Job> arrayList = new ArrayList<Job>(n);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(SCHEDULE_IMMEDIATE);
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            preparedStatement.setMaxRows(n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Map map;
                Object object;
                try {
                    object = new ObjectInputStream(resultSet.getBinaryStream(5));
                    map = (Map)((ObjectInputStream)object).readObject();
                    ((ObjectInputStream)object).close();
                }
                catch (Exception exception) {
                    throw new DatabaseException("Error deserializing job details", exception);
                }
                object = new Job(resultSet.getLong(2), resultSet.getString(1), this.asBoolean(resultSet.getInt(3)), map);
                arrayList.add((Job)object);
            }
            resultSet.close();
            preparedStatement.close();
            this.close(preparedStatement);
            this.close(connection);
        }
        catch (SQLException sQLException) {
            try {
                throw new DatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                this.close(connection);
                throw throwable;
            }
        }
        return arrayList;
    }

    @Override
    public int updateReassign(String string, String string2) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateReassign from " + string + " ---> " + string2));
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(UPDATE_REASSIGN);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            int n = preparedStatement.executeUpdate();
            this.close(preparedStatement);
            this.close(connection);
            return n;
        }
        catch (SQLException sQLException) {
            try {
                throw new DatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                this.close(connection);
                throw throwable;
            }
        }
    }

    @Override
    public int updateAssignToNode(String string, int n, int n2, long l) throws DatabaseException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("updateAsssignToNode node=" + string + " " + n + "/" + n2 + " maxtime=" + l));
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = this._dialect == Dialect.SQLSERVER ? connection.prepareStatement(UPGRADE_JOB_SQLSERVER) : (this._dialect == Dialect.DB2 ? connection.prepareStatement(UPGRADE_JOB_DB2) : (this._dialect == Dialect.SYBASE ? connection.prepareStatement(UPGRADE_JOB_SYBASE) : (this._dialect == Dialect.SYBASE12 ? connection.prepareStatement(UPGRADE_JOB_SYBASE12) : connection.prepareStatement(UPGRADE_JOB_DEFAULT))));
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n2);
            preparedStatement.setInt(3, n);
            preparedStatement.setLong(4, l);
            int n3 = preparedStatement.executeUpdate();
            this.close(preparedStatement);
            this.close(connection);
            return n3;
        }
        catch (SQLException sQLException) {
            try {
                throw new DatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                this.close(connection);
                throw throwable;
            }
        }
    }

    private Connection getConnection() throws SQLException {
        Connection connection = this._ds.getConnection();
        DbIsolation.setIsolationLevel((Connection)connection);
        return connection;
    }

    private int asInteger(boolean bl) {
        return bl ? 1 : 0;
    }

    private boolean asBoolean(int n) {
        return n != 0;
    }

    private void close(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                __log.warn((Object)"Exception while closing prepared statement", (Throwable)exception);
            }
        }
    }

    private void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                __log.warn((Object)"Exception while closing connection", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dialect guessDialect() {
        Dialect dialect = Dialect.UNKNOWN;
        Connection connection = null;
        try {
            connection = this.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null) {
                String string = databaseMetaData.getDatabaseProductName();
                int n = databaseMetaData.getDatabaseMajorVersion();
                __log.info((Object)("Using database " + string + " major version " + n));
                if (string.indexOf("DB2") >= 0) {
                    dialect = Dialect.DB2;
                } else if (string.indexOf("Derby") >= 0) {
                    dialect = Dialect.DERBY;
                } else if (string.indexOf("Firebird") >= 0) {
                    dialect = Dialect.FIREBIRD;
                } else if (string.indexOf("HSQL") >= 0) {
                    dialect = Dialect.HSQL;
                } else if (string.indexOf("Microsoft SQL") >= 0) {
                    dialect = Dialect.SQLSERVER;
                } else if (string.indexOf("MySQL") >= 0) {
                    dialect = Dialect.MYSQL;
                } else if (string.indexOf("Sybase") >= 0 || string.indexOf("Adaptive") >= 0) {
                    dialect = Dialect.SYBASE;
                    if (n == 12) {
                        dialect = Dialect.SYBASE12;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            __log.warn((Object)"Unable to determine database dialect", (Throwable)sQLException);
        }
        finally {
            this.close(connection);
        }
        __log.info((Object)("Using database dialect: " + (Object)((Object)dialect)));
        return dialect;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Dialect {
        DB2,
        DERBY,
        FIREBIRD,
        HSQL,
        MYSQL,
        ORACLE,
        SQLSERVER,
        SYBASE,
        SYBASE12,
        UNKNOWN;

    }
}

