/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.Collection;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ProcessManagementDAO;
import org.apache.ode.dao.jpa.ProcessInstanceDAOImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessManagementDAOImpl
implements ProcessManagementDAO {
    private static final Log __log = LogFactory.getLog(ProcessManagementDAOImpl.class);
    private EntityManager em;

    public ProcessManagementDAOImpl(EntityManager entityManager) {
        this.em = entityManager;
    }

    public Object[] findFailedCountAndLastFailedDateForProcessId(BpelDAOConnection bpelDAOConnection, String string, String string2) {
        Query query = this.em.createNamedQuery("COUNT_FAILED_INSTANCES_BY_STATUS_AND_PROCESS_ID");
        query.setParameter("states", (Object)new InstanceFilter("status=" + string).convertFilterState());
        query.setParameter("processId", (Object)string2);
        return (Object[])query.getSingleResult();
    }

    public void prefetchActivityFailureCounts(Collection<ProcessInstanceDAO> collection) {
        Object object;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("Prefetching activity failure counts for " + collection.size() + " instances."));
        }
        if (collection.isEmpty()) {
            return;
        }
        Query query = this.em.createNamedQuery("COUNT_ACTIVITY_RECOVERIES_BY_INSTANCES");
        query.setParameter("instances", collection);
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        for (Object object2 : query.getResultList()) {
            object = ((Object[])object2)[0];
            Object object3 = ((Object[])object2)[0];
            hashMap.put((Long)object, (Long)object3);
        }
        for (ProcessInstanceDAO processInstanceDAO : collection) {
            object = (Long)hashMap.get(processInstanceDAO.getInstanceId());
            if (object == null) continue;
            ((ProcessInstanceDAOImpl)processInstanceDAO).setActivityFailureCount(((Long)object).intValue());
        }
    }
}

