/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.ActivityRecoveryDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.FaultDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.dao.jpa.ActivityRecoveryDAOImpl;
import org.apache.ode.dao.jpa.BPELDAOConnectionImpl;
import org.apache.ode.dao.jpa.CorrelatorDAOImpl;
import org.apache.ode.dao.jpa.FaultDAOImpl;
import org.apache.ode.dao.jpa.MessageExchangeDAOImpl;
import org.apache.ode.dao.jpa.OpenJPADAO;
import org.apache.ode.dao.jpa.ProcessDAOImpl;
import org.apache.ode.dao.jpa.ScopeDAOImpl;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ODE_PROCESS_INSTANCE")
@NamedQueries(value={@NamedQuery(name="DELETE_INSTANCES_BY_PROCESS", query="delete from ProcessInstanceDAOImpl as i where i._process = :process"), @NamedQuery(name="SELECT_INSTANCE_IDS_BY_PROCESS", query="select i._instanceId from ProcessInstanceDAOImpl as i where i._process = :process"), @NamedQuery(name="COUNT_INSTANCE_IDS_BY_PROCESS", query="select count(i._instanceId) from ProcessInstanceDAOImpl as i where i._process = :process"), @NamedQuery(name="SELECT_FAULT_IDS_BY_PROCESS", query="select i._faultId from ProcessInstanceDAOImpl as i where i._process = :process and i._faultId is not null"), @NamedQuery(name="COUNT_FAILED_INSTANCES_BY_STATUS_AND_PROCESS_ID", query="select count(i._instanceId), max(i._lastRecovery) from ProcessInstanceDAOImpl as i where i._process._processId = :processId and i._state in(:states) and exists(select r from ActivityRecoveryDAOImpl r where i = r._instance)")})
public class ProcessInstanceDAOImpl
extends OpenJPADAO
implements ProcessInstanceDAO,
PersistenceCapable {
    private static final Log __log = LogFactory.getLog(ProcessInstanceDAOImpl.class);
    public static final String DELETE_INSTANCES_BY_PROCESS = "DELETE_INSTANCES_BY_PROCESS";
    public static final String SELECT_INSTANCE_IDS_BY_PROCESS = "SELECT_INSTANCE_IDS_BY_PROCESS";
    public static final String COUNT_INSTANCE_IDS_BY_PROCESS = "COUNT_INSTANCE_IDS_BY_PROCESS";
    public static final String SELECT_FAULT_IDS_BY_PROCESS = "SELECT_FAULT_IDS_BY_PROCESS";
    public static final String COUNT_FAILED_INSTANCES_BY_STATUS_AND_PROCESS_ID = "COUNT_FAILED_INSTANCES_BY_STATUS_AND_PROCESS_ID";
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _instanceId;
    @Basic
    @Column(name="LAST_RECOVERY_DATE")
    private Date _lastRecovery;
    @Basic
    @Column(name="LAST_ACTIVE_TIME")
    private Date _lastActive;
    @Basic
    @Column(name="INSTANCE_STATE")
    private short _state;
    @Basic
    @Column(name="PREVIOUS_STATE")
    private short _previousState;
    @Lob
    @Column(name="EXECUTION_STATE")
    private byte[] _executionState;
    @Basic
    @Column(name="SEQUENCE")
    private long _sequence;
    @Basic
    @Column(name="DATE_CREATED")
    private Date _dateCreated;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Column(name="ROOT_SCOPE_ID")
    private ScopeDAOImpl _rootScope;
    @OneToMany(targetEntity=ScopeDAOImpl.class, mappedBy="_processInstance", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Collection<ScopeDAO> _scopes;
    @OneToMany(targetEntity=ActivityRecoveryDAOImpl.class, mappedBy="_instance", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<ActivityRecoveryDAO> _recoveries;
    @Basic
    @Column(name="FAULT_ID", insertable=false, updatable=false, nullable=true)
    private long _faultId;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Column(name="FAULT_ID")
    private FaultDAOImpl _fault;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @Column(name="PROCESS_ID")
    private ProcessDAOImpl _process;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @Column(name="INSTANTIATING_CORRELATOR_ID")
    private CorrelatorDAOImpl _instantiatingCorrelator;
    @OneToMany(targetEntity=MessageExchangeDAOImpl.class, mappedBy="_processInst", fetch=FetchType.LAZY)
    private Collection<MessageExchangeDAO> _messageExchanges;
    private transient int _activityFailureCount;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$L$B;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$FaultDAOImpl;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$ScopeDAOImpl;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl;
    private transient Object pcDetachedState;

    public ProcessInstanceDAOImpl() {
        ProcessInstanceDAOImpl.pcSet_dateCreated(this, new Date());
        ProcessInstanceDAOImpl.pcSet_scopes(this, new ArrayList());
        ProcessInstanceDAOImpl.pcSet_recoveries(this, new ArrayList());
        ProcessInstanceDAOImpl.pcSet_messageExchanges(this, new ArrayList());
        this._activityFailureCount = -1;
    }

    public ProcessInstanceDAOImpl(CorrelatorDAOImpl correlatorDAOImpl, ProcessDAOImpl processDAOImpl) {
        ProcessInstanceDAOImpl.pcSet_dateCreated(this, new Date());
        ProcessInstanceDAOImpl.pcSet_scopes(this, new ArrayList());
        ProcessInstanceDAOImpl.pcSet_recoveries(this, new ArrayList());
        ProcessInstanceDAOImpl.pcSet_messageExchanges(this, new ArrayList());
        this._activityFailureCount = -1;
        ProcessInstanceDAOImpl.pcSet_instantiatingCorrelator(this, correlatorDAOImpl);
        ProcessInstanceDAOImpl.pcSet_process(this, processDAOImpl);
    }

    public void createActivityRecovery(String string, long l, String string2, Date date, Element element, String[] stringArray, int n) {
        ActivityRecoveryDAOImpl activityRecoveryDAOImpl = new ActivityRecoveryDAOImpl(string, l, string2, date, element, stringArray, n);
        ProcessInstanceDAOImpl.pcGet_recoveries(this).add(activityRecoveryDAOImpl);
        activityRecoveryDAOImpl.setInstance(this);
        ProcessInstanceDAOImpl.pcSet_lastRecovery(this, date);
    }

    public ScopeDAO createScope(ScopeDAO scopeDAO, String string, int n) {
        ScopeDAOImpl scopeDAOImpl = new ScopeDAOImpl((ScopeDAOImpl)scopeDAO, string, n, this);
        scopeDAOImpl.setState(ScopeStateEnum.ACTIVE);
        ProcessInstanceDAOImpl.pcGet_scopes(this).add(scopeDAOImpl);
        ProcessInstanceDAOImpl.pcSet_rootScope(this, scopeDAO == null ? scopeDAOImpl : ProcessInstanceDAOImpl.pcGet_rootScope(this));
        this.getEM().persist((Object)scopeDAOImpl);
        return scopeDAOImpl;
    }

    public Collection<CorrelationSetDAO> selectCorrelationSets(Collection<ProcessInstanceDAO> collection) {
        return this.getEM().createNamedQuery("SELECT_CORRELATION_SETS_BY_INSTANCES").setParameter("instances", collection).getResultList();
    }

    public void delete(Set<ProcessConf.CLEANUP_CATEGORY> set) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Cleaning up instance Data with " + set));
        }
        this.setExecutionState(null);
        if (this.getEM() != null) {
            if (!set.isEmpty()) {
                this.getEM().flush();
            }
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.EVENTS)) {
                this.deleteEvents();
            }
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS)) {
                this.deleteCorrelations();
            }
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.MESSAGES)) {
                this.deleteMessageRoutes();
            }
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.VARIABLES)) {
                this.deleteVariables();
            }
            if (set.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE)) {
                this.deleteInstance();
            }
            this.getEM().flush();
        }
    }

    private void deleteInstance() {
        if (ProcessInstanceDAOImpl.pcGet_fault(this) != null) {
            this.getEM().remove((Object)ProcessInstanceDAOImpl.pcGet_fault(this));
        }
        this.getEM().remove((Object)this);
    }

    private void deleteVariables() {
        List list = this.getEM().createNamedQuery("SELECT_XMLDATA_IDS_BY_INSTANCE").setParameter("instance", (Object)this).getResultList();
        this.batchUpdateByIds(list.iterator(), this.getEM().createNamedQuery("DELETE_XML_DATA_PROPERTIES_BY_XML_DATA_IDS"), "xmlDataIds");
        List list2 = this.getEM().createNamedQuery("SELECT_SCOPE_IDS_BY_INSTANCE").setParameter("instance", (Object)this).getResultList();
        this.batchUpdateByIds(list2.iterator(), this.getEM().createNamedQuery("DELETE_XMLDATA_BY_SCOPE_IDS"), "scopeIds");
        this.batchUpdateByIds(list2.iterator(), this.getEM().createNamedQuery("DELETE_PARTNER_LINKS_BY_SCOPE_IDS"), "scopeIds");
        this.batchUpdateByIds(list2.iterator(), this.getEM().createNamedQuery("DELETE_SCOPES_BY_SCOPE_IDS"), "ids");
    }

    private void deleteMessageRoutes() {
        this.getEM().createNamedQuery("DELETE_MESSAGE_ROUTES_BY_INSTANCE").setParameter("instance", (Object)this).executeUpdate();
    }

    private void deleteCorrelations() {
        List list = this.getEM().createNamedQuery("SELECT_CORRELATION_SET_IDS_BY_INSTANCE").setParameter("instance", (Object)this).getResultList();
        this.batchUpdateByIds(list.iterator(), this.getEM().createNamedQuery("DELETE_CORSET_PROPERTIES_BY_PROPERTY_IDS"), "corrSetIds");
        this.batchUpdateByIds(list.iterator(), this.getEM().createNamedQuery("DELETE_CORRELATION_SETS_BY_IDS"), "ids");
    }

    private void deleteEvents() {
        this.getEM().createNamedQuery("DELETE_EVENTS_BY_INSTANCE").setParameter("instance", (Object)this).executeUpdate();
    }

    public void deleteActivityRecovery(String string) {
        ActivityRecoveryDAOImpl activityRecoveryDAOImpl = null;
        for (ActivityRecoveryDAO activityRecoveryDAO : ProcessInstanceDAOImpl.pcGet_recoveries(this)) {
            ActivityRecoveryDAOImpl activityRecoveryDAOImpl2 = (ActivityRecoveryDAOImpl)activityRecoveryDAO;
            if (!activityRecoveryDAOImpl2.getChannel().equals(string)) continue;
            activityRecoveryDAOImpl = activityRecoveryDAOImpl2;
            break;
        }
        if (activityRecoveryDAOImpl != null) {
            this.getEM().remove(activityRecoveryDAOImpl);
            ProcessInstanceDAOImpl.pcGet_recoveries(this).remove(activityRecoveryDAOImpl);
        }
    }

    public void finishCompletion() {
        assert (ProcessState.isFinished((short)this.getState()));
    }

    public long genMonotonic() {
        ProcessInstanceDAOImpl processInstanceDAOImpl = this;
        long l = ProcessInstanceDAOImpl.pcGet_sequence(processInstanceDAOImpl);
        ProcessInstanceDAOImpl.pcSet_sequence(processInstanceDAOImpl, l + 1L);
        return l;
    }

    public int getActivityFailureCount() {
        if (this._activityFailureCount == -1) {
            this._activityFailureCount = ProcessInstanceDAOImpl.pcGet_recoveries(this).size();
        }
        return this._activityFailureCount;
    }

    public void setActivityFailureCount(int n) {
        this._activityFailureCount = n;
    }

    public Date getActivityFailureDateTime() {
        return ProcessInstanceDAOImpl.pcGet_lastRecovery(this);
    }

    public Collection<ActivityRecoveryDAO> getActivityRecoveries() {
        return ProcessInstanceDAOImpl.pcGet_recoveries(this);
    }

    public CorrelationSetDAO getCorrelationSet(String string) {
        throw new UnsupportedOperationException();
    }

    public Set<CorrelationSetDAO> getCorrelationSets() {
        return new HashSet<CorrelationSetDAO>();
    }

    public Date getCreateTime() {
        return ProcessInstanceDAOImpl.pcGet_dateCreated(this);
    }

    public ProcessInstanceDAO.EventsFirstLastCountTuple getEventsFirstLastCount() {
        return null;
    }

    public byte[] getExecutionState() {
        return ProcessInstanceDAOImpl.pcGet_executionState(this);
    }

    public FaultDAO getFault() {
        return ProcessInstanceDAOImpl.pcGet_fault(this);
    }

    public Long getInstanceId() {
        return ProcessInstanceDAOImpl.pcGet_instanceId(this);
    }

    public CorrelatorDAO getInstantiatingCorrelator() {
        return ProcessInstanceDAOImpl.pcGet_instantiatingCorrelator(this);
    }

    public Date getLastActiveTime() {
        return ProcessInstanceDAOImpl.pcGet_lastActive(this);
    }

    public short getPreviousState() {
        return ProcessInstanceDAOImpl.pcGet_previousState(this);
    }

    public ProcessDAO getProcess() {
        return ProcessInstanceDAOImpl.pcGet_process(this);
    }

    public ScopeDAO getRootScope() {
        return ProcessInstanceDAOImpl.pcGet_rootScope(this);
    }

    public ScopeDAO getScope(Long l) {
        return (ScopeDAO)this.getEM().find(ScopeDAOImpl.class, (Object)l);
    }

    public Collection<ScopeDAO> getScopes(String string) {
        ArrayList<ScopeDAO> arrayList = new ArrayList<ScopeDAO>();
        for (ScopeDAO scopeDAO : ProcessInstanceDAOImpl.pcGet_scopes(this)) {
            if (!scopeDAO.getName().equals(string)) continue;
            arrayList.add(scopeDAO);
        }
        return arrayList;
    }

    public Collection<ScopeDAO> getScopes() {
        return ProcessInstanceDAOImpl.pcGet_scopes(this);
    }

    public short getState() {
        return ProcessInstanceDAOImpl.pcGet_state(this);
    }

    public XmlDataDAO[] getVariables(String string, int n) {
        ArrayList<XmlDataDAO> arrayList = new ArrayList<XmlDataDAO>();
        for (ScopeDAO scopeDAO : ProcessInstanceDAOImpl.pcGet_scopes(this)) {
            XmlDataDAO xmlDataDAO;
            if (scopeDAO.getModelId() != n || (xmlDataDAO = scopeDAO.getVariable(string)) == null) continue;
            arrayList.add(xmlDataDAO);
        }
        return arrayList.toArray(new XmlDataDAO[arrayList.size()]);
    }

    public void insertBpelEvent(ProcessInstanceEvent processInstanceEvent) {
        this.getConn().insertBpelEvent((BpelEvent)processInstanceEvent, this.getProcess(), this);
    }

    public void setExecutionState(byte[] byArray) {
        ProcessInstanceDAOImpl.pcSet_executionState(this, byArray);
    }

    public void setFault(FaultDAO faultDAO) {
        ProcessInstanceDAOImpl.pcSet_fault(this, (FaultDAOImpl)faultDAO);
    }

    public void setFault(QName qName, String string, int n, int n2, Element element) {
        ProcessInstanceDAOImpl.pcSet_fault(this, new FaultDAOImpl(qName, string, n, n2, element));
    }

    public void setLastActiveTime(Date date) {
        ProcessInstanceDAOImpl.pcSet_lastActive(this, date);
    }

    public void setState(short s) {
        ProcessInstanceDAOImpl.pcSet_previousState(this, ProcessInstanceDAOImpl.pcGet_state(this));
        ProcessInstanceDAOImpl.pcSet_state(this, s);
    }

    void removeRoutes(String string) {
        ProcessInstanceDAOImpl.pcGet_process(this).removeRoutes(string, this);
    }

    public BpelDAOConnection getConnection() {
        return new BPELDAOConnectionImpl(this.getEM());
    }

    static {
        pcFieldNames = new String[]{"_dateCreated", "_executionState", "_fault", "_faultId", "_instanceId", "_instantiatingCorrelator", "_lastActive", "_lastRecovery", "_messageExchanges", "_previousState", "_process", "_recoveries", "_rootScope", "_scopes", "_sequence", "_state"};
        Class[] classArray = new Class[16];
        Class clazz = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = ProcessInstanceDAOImpl.class$("java.util.Date"));
        classArray[0] = clazz;
        Class clazz2 = class$L$B != null ? class$L$B : (class$L$B = ProcessInstanceDAOImpl.class$("[B"));
        classArray[1] = clazz2;
        Class clazz3 = class$Lorg$apache$ode$dao$jpa$FaultDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$FaultDAOImpl : (class$Lorg$apache$ode$dao$jpa$FaultDAOImpl = ProcessInstanceDAOImpl.class$("org.apache.ode.dao.jpa.FaultDAOImpl"));
        classArray[2] = clazz3;
        classArray[3] = Long.TYPE;
        Class clazz4 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = ProcessInstanceDAOImpl.class$("java.lang.Long"));
        classArray[4] = clazz4;
        Class clazz5 = class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl : (class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl = ProcessInstanceDAOImpl.class$("org.apache.ode.dao.jpa.CorrelatorDAOImpl"));
        classArray[5] = clazz5;
        classArray[6] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = ProcessInstanceDAOImpl.class$("java.util.Date"));
        classArray[7] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = ProcessInstanceDAOImpl.class$("java.util.Date"));
        Class clazz6 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = ProcessInstanceDAOImpl.class$("java.util.Collection"));
        classArray[8] = clazz6;
        classArray[9] = Short.TYPE;
        Class clazz7 = class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl = ProcessInstanceDAOImpl.class$("org.apache.ode.dao.jpa.ProcessDAOImpl"));
        classArray[10] = clazz7;
        classArray[11] = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = ProcessInstanceDAOImpl.class$("java.util.Collection"));
        Class clazz8 = class$Lorg$apache$ode$dao$jpa$ScopeDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ScopeDAOImpl : (class$Lorg$apache$ode$dao$jpa$ScopeDAOImpl = ProcessInstanceDAOImpl.class$("org.apache.ode.dao.jpa.ScopeDAOImpl"));
        classArray[12] = clazz8;
        classArray[13] = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = ProcessInstanceDAOImpl.class$("java.util.Collection"));
        classArray[14] = Long.TYPE;
        classArray[15] = Short.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 21, 5, 26, 26, 5, 26, 26, 5, 26, 5, 5, 5, 5, 26, 26};
        Class clazz9 = class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl = ProcessInstanceDAOImpl.class$("org.apache.ode.dao.jpa.ProcessInstanceDAOImpl"));
        PCRegistry.register((Class)clazz9, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"ProcessInstanceDAOImpl", (PersistenceCapable)new ProcessInstanceDAOImpl());
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this._dateCreated = null;
        this._executionState = null;
        this._fault = null;
        this._faultId = 0L;
        this._instanceId = null;
        this._instantiatingCorrelator = null;
        this._lastActive = null;
        this._lastRecovery = null;
        this._messageExchanges = null;
        this._previousState = 0;
        this._process = null;
        this._recoveries = null;
        this._rootScope = null;
        this._scopes = null;
        this._sequence = 0L;
        this._state = 0;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        ProcessInstanceDAOImpl processInstanceDAOImpl = new ProcessInstanceDAOImpl();
        if (bl) {
            processInstanceDAOImpl.pcClearFields();
        }
        processInstanceDAOImpl.pcStateManager = stateManager;
        processInstanceDAOImpl.pcCopyKeyFieldsFromObjectId(object);
        return processInstanceDAOImpl;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        ProcessInstanceDAOImpl processInstanceDAOImpl = new ProcessInstanceDAOImpl();
        if (bl) {
            processInstanceDAOImpl.pcClearFields();
        }
        processInstanceDAOImpl.pcStateManager = stateManager;
        return processInstanceDAOImpl;
    }

    protected static int pcGetManagedFieldCount() {
        return 16;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._dateCreated = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this._executionState = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this._fault = (FaultDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this._faultId = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this._instanceId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this._instantiatingCorrelator = (CorrelatorDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this._lastActive = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this._lastRecovery = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this._messageExchanges = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this._previousState = this.pcStateManager.replaceShortField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this._process = (ProcessDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this._recoveries = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this._rootScope = (ScopeDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this._scopes = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this._sequence = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this._state = this.pcStateManager.replaceShortField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._dateCreated);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._executionState);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._fault);
                return;
            }
            case 3: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this._faultId);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._instanceId);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._instantiatingCorrelator);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._lastActive);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._lastRecovery);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._messageExchanges);
                return;
            }
            case 9: {
                this.pcStateManager.providedShortField((PersistenceCapable)this, n, this._previousState);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._process);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._recoveries);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._rootScope);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._scopes);
                return;
            }
            case 14: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this._sequence);
                return;
            }
            case 15: {
                this.pcStateManager.providedShortField((PersistenceCapable)this, n, this._state);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(ProcessInstanceDAOImpl processInstanceDAOImpl, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._dateCreated = processInstanceDAOImpl._dateCreated;
                return;
            }
            case 1: {
                this._executionState = processInstanceDAOImpl._executionState;
                return;
            }
            case 2: {
                this._fault = processInstanceDAOImpl._fault;
                return;
            }
            case 3: {
                this._faultId = processInstanceDAOImpl._faultId;
                return;
            }
            case 4: {
                this._instanceId = processInstanceDAOImpl._instanceId;
                return;
            }
            case 5: {
                this._instantiatingCorrelator = processInstanceDAOImpl._instantiatingCorrelator;
                return;
            }
            case 6: {
                this._lastActive = processInstanceDAOImpl._lastActive;
                return;
            }
            case 7: {
                this._lastRecovery = processInstanceDAOImpl._lastRecovery;
                return;
            }
            case 8: {
                this._messageExchanges = processInstanceDAOImpl._messageExchanges;
                return;
            }
            case 9: {
                this._previousState = processInstanceDAOImpl._previousState;
                return;
            }
            case 10: {
                this._process = processInstanceDAOImpl._process;
                return;
            }
            case 11: {
                this._recoveries = processInstanceDAOImpl._recoveries;
                return;
            }
            case 12: {
                this._rootScope = processInstanceDAOImpl._rootScope;
                return;
            }
            case 13: {
                this._scopes = processInstanceDAOImpl._scopes;
                return;
            }
            case 14: {
                this._sequence = processInstanceDAOImpl._sequence;
                return;
            }
            case 15: {
                this._state = processInstanceDAOImpl._state;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        ProcessInstanceDAOImpl processInstanceDAOImpl = (ProcessInstanceDAOImpl)object;
        if (processInstanceDAOImpl.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(processInstanceDAOImpl, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(4 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this._instanceId = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl = ProcessInstanceDAOImpl.class$("org.apache.ode.dao.jpa.ProcessInstanceDAOImpl"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessInstanceDAOImpl = ProcessInstanceDAOImpl.class$("org.apache.ode.dao.jpa.ProcessInstanceDAOImpl"));
        return new LongId(clazz, this._instanceId);
    }

    private static final Date pcGet_dateCreated(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._dateCreated;
        }
        int n = pcInheritedFieldCount + 0;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._dateCreated;
    }

    private static final void pcSet_dateCreated(ProcessInstanceDAOImpl processInstanceDAOImpl, Date date) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._dateCreated = date;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 0, (Object)processInstanceDAOImpl._dateCreated, (Object)date, 0);
    }

    private static final byte[] pcGet_executionState(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._executionState;
        }
        int n = pcInheritedFieldCount + 1;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._executionState;
    }

    private static final void pcSet_executionState(ProcessInstanceDAOImpl processInstanceDAOImpl, byte[] byArray) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._executionState = byArray;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 1, (Object)processInstanceDAOImpl._executionState, (Object)byArray, 0);
    }

    private static final FaultDAOImpl pcGet_fault(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._fault;
        }
        int n = pcInheritedFieldCount + 2;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._fault;
    }

    private static final void pcSet_fault(ProcessInstanceDAOImpl processInstanceDAOImpl, FaultDAOImpl faultDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._fault = faultDAOImpl;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 2, (Object)processInstanceDAOImpl._fault, (Object)faultDAOImpl, 0);
    }

    private static final long pcGet_faultId(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._faultId;
        }
        int n = pcInheritedFieldCount + 3;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._faultId;
    }

    private static final void pcSet_faultId(ProcessInstanceDAOImpl processInstanceDAOImpl, long l) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._faultId = l;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingLongField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 3, processInstanceDAOImpl._faultId, l, 0);
    }

    private static final Long pcGet_instanceId(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._instanceId;
        }
        int n = pcInheritedFieldCount + 4;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._instanceId;
    }

    private static final void pcSet_instanceId(ProcessInstanceDAOImpl processInstanceDAOImpl, Long l) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._instanceId = l;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 4, (Object)processInstanceDAOImpl._instanceId, (Object)l, 0);
    }

    private static final CorrelatorDAOImpl pcGet_instantiatingCorrelator(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._instantiatingCorrelator;
        }
        int n = pcInheritedFieldCount + 5;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._instantiatingCorrelator;
    }

    private static final void pcSet_instantiatingCorrelator(ProcessInstanceDAOImpl processInstanceDAOImpl, CorrelatorDAOImpl correlatorDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._instantiatingCorrelator = correlatorDAOImpl;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 5, (Object)processInstanceDAOImpl._instantiatingCorrelator, (Object)correlatorDAOImpl, 0);
    }

    private static final Date pcGet_lastActive(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._lastActive;
        }
        int n = pcInheritedFieldCount + 6;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._lastActive;
    }

    private static final void pcSet_lastActive(ProcessInstanceDAOImpl processInstanceDAOImpl, Date date) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._lastActive = date;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 6, (Object)processInstanceDAOImpl._lastActive, (Object)date, 0);
    }

    private static final Date pcGet_lastRecovery(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._lastRecovery;
        }
        int n = pcInheritedFieldCount + 7;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._lastRecovery;
    }

    private static final void pcSet_lastRecovery(ProcessInstanceDAOImpl processInstanceDAOImpl, Date date) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._lastRecovery = date;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 7, (Object)processInstanceDAOImpl._lastRecovery, (Object)date, 0);
    }

    private static final Collection pcGet_messageExchanges(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._messageExchanges;
        }
        int n = pcInheritedFieldCount + 8;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._messageExchanges;
    }

    private static final void pcSet_messageExchanges(ProcessInstanceDAOImpl processInstanceDAOImpl, Collection collection) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._messageExchanges = collection;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 8, processInstanceDAOImpl._messageExchanges, (Object)collection, 0);
    }

    private static final short pcGet_previousState(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._previousState;
        }
        int n = pcInheritedFieldCount + 9;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._previousState;
    }

    private static final void pcSet_previousState(ProcessInstanceDAOImpl processInstanceDAOImpl, short s) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._previousState = s;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingShortField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 9, processInstanceDAOImpl._previousState, s, 0);
    }

    private static final ProcessDAOImpl pcGet_process(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._process;
        }
        int n = pcInheritedFieldCount + 10;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._process;
    }

    private static final void pcSet_process(ProcessInstanceDAOImpl processInstanceDAOImpl, ProcessDAOImpl processDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._process = processDAOImpl;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 10, (Object)processInstanceDAOImpl._process, (Object)processDAOImpl, 0);
    }

    private static final Collection pcGet_recoveries(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._recoveries;
        }
        int n = pcInheritedFieldCount + 11;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._recoveries;
    }

    private static final void pcSet_recoveries(ProcessInstanceDAOImpl processInstanceDAOImpl, Collection collection) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._recoveries = collection;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 11, processInstanceDAOImpl._recoveries, (Object)collection, 0);
    }

    private static final ScopeDAOImpl pcGet_rootScope(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._rootScope;
        }
        int n = pcInheritedFieldCount + 12;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._rootScope;
    }

    private static final void pcSet_rootScope(ProcessInstanceDAOImpl processInstanceDAOImpl, ScopeDAOImpl scopeDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._rootScope = scopeDAOImpl;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 12, (Object)processInstanceDAOImpl._rootScope, (Object)scopeDAOImpl, 0);
    }

    private static final Collection pcGet_scopes(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._scopes;
        }
        int n = pcInheritedFieldCount + 13;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._scopes;
    }

    private static final void pcSet_scopes(ProcessInstanceDAOImpl processInstanceDAOImpl, Collection collection) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._scopes = collection;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 13, processInstanceDAOImpl._scopes, (Object)collection, 0);
    }

    private static final long pcGet_sequence(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._sequence;
        }
        int n = pcInheritedFieldCount + 14;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._sequence;
    }

    private static final void pcSet_sequence(ProcessInstanceDAOImpl processInstanceDAOImpl, long l) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._sequence = l;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingLongField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 14, processInstanceDAOImpl._sequence, l, 0);
    }

    private static final short pcGet_state(ProcessInstanceDAOImpl processInstanceDAOImpl) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            return processInstanceDAOImpl._state;
        }
        int n = pcInheritedFieldCount + 15;
        processInstanceDAOImpl.pcStateManager.accessingField(n);
        return processInstanceDAOImpl._state;
    }

    private static final void pcSet_state(ProcessInstanceDAOImpl processInstanceDAOImpl, short s) {
        if (processInstanceDAOImpl.pcStateManager == null) {
            processInstanceDAOImpl._state = s;
            return;
        }
        processInstanceDAOImpl.pcStateManager.settingShortField((PersistenceCapable)processInstanceDAOImpl, pcInheritedFieldCount + 15, processInstanceDAOImpl._state, s, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

