/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.jpa.BPELDAOConnectionFactoryImpl;
import org.apache.ode.dao.jpa.BPELDAOConnectionImpl;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenJPADAO {
    private static final Log __log = LogFactory.getLog(OpenJPADAO.class);

    protected BPELDAOConnectionImpl getConn() {
        return BPELDAOConnectionFactoryImpl._connections.get();
    }

    protected EntityManager getEM() {
        return OpenJPAPersistence.getEntityManager((Object)this);
    }

    protected <T> T getSingleResult(Query query) {
        List list = query.getResultList();
        if (list.size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    protected <T> void batchUpdateByIds(Iterator<T> iterator, Query query, String string) {
        if (query instanceof OpenJPAQuery) {
            OpenJPAQuery openJPAQuery = (OpenJPAQuery)query;
            int n = openJPAQuery.getFetchPlan().getFetchBatchSize();
            if (__log.isTraceEnabled()) {
                __log.trace((Object)("BATCH fetchBatchSize = " + n));
            }
            ArrayList<T> arrayList = new ArrayList<T>();
            while (iterator.hasNext()) {
                for (int i = 0; i < n && iterator.hasNext(); ++i) {
                    arrayList.add(iterator.next());
                }
                if (__log.isTraceEnabled()) {
                    __log.trace((Object)("BATCH updating " + arrayList.size() + " objects."));
                }
                query.setParameter(string, arrayList);
                query.executeUpdate();
                arrayList.clear();
            }
        }
    }
}

