/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.util.GeneralException;

public class JpaTxMgrProvider
implements ManagedRuntime {
    private TransactionManager _txMgr;

    public JpaTxMgrProvider(TransactionManager transactionManager) {
        this._txMgr = transactionManager;
    }

    public TransactionManager getTransactionManager() throws Exception {
        return this._txMgr;
    }

    public void setRollbackOnly(Throwable throwable) throws Exception {
        this.getTransactionManager().getTransaction().setRollbackOnly();
    }

    public Throwable getRollbackCause() throws Exception {
        return null;
    }

    public Object getTransactionKey() throws Exception, SystemException {
        return this._txMgr.getTransaction();
    }

    public void doNonTransactionalWork(Runnable runnable) throws NotSupportedException {
        TransactionManager transactionManager = null;
        Transaction transaction = null;
        try {
            transactionManager = this.getTransactionManager();
            transaction = transactionManager.suspend();
        }
        catch (Exception exception) {
            NotSupportedException notSupportedException = new NotSupportedException(exception.getMessage());
            notSupportedException.initCause((Throwable)exception);
            throw notSupportedException;
        }
        runnable.run();
        try {
            transactionManager.resume(transaction);
        }
        catch (Exception exception) {
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException systemException) {
                throw new GeneralException((Throwable)systemException);
            }
            NotSupportedException notSupportedException = new NotSupportedException(exception.getMessage());
            notSupportedException.initCause((Throwable)exception);
            throw notSupportedException;
        }
    }
}

