/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.IfGeneratorMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.IfActivity;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OSwitch;
import org.apache.ode.utils.msg.MessageBundle;

class IfGenerator
extends DefaultActivityGenerator {
    private static final IfGeneratorMessages __cmsgs = (IfGeneratorMessages)MessageBundle.getMessages(IfGeneratorMessages.class);

    IfGenerator() {
    }

    public OActivity newInstance(Activity activity) {
        return new OSwitch(this._context.getOProcess(), this._context.getCurrent());
    }

    public void compile(OActivity oActivity, Activity activity) {
        OSwitch oSwitch = (OSwitch)oActivity;
        IfActivity ifActivity = (IfActivity)activity;
        if (ifActivity.getCondition() == null) {
            throw new CompilationException(__cmsgs.errIfWithNoCondition());
        }
        boolean bl = true;
        if (ifActivity.getActivity() != null) {
            OSwitch.OCase oCase = new OSwitch.OCase(this._context.getOProcess());
            oCase.activity = this._context.compile(ifActivity.getActivity());
            oCase.expression = this._context.compileExpr(ifActivity.getCondition());
            oSwitch.addCase(oCase);
            bl = false;
        }
        for (IfActivity.Case case_ : ifActivity.getCases()) {
            OSwitch.OCase oCase = new OSwitch.OCase(this._context.getOProcess());
            oCase.activity = this._context.compile(case_.getActivity());
            oCase.expression = bl ? this._context.compileExpr(ifActivity.getCondition()) : (case_.getCondition() == null ? this._context.constantExpr(true) : this._context.compileExpr(case_.getCondition()));
            oSwitch.addCase(oCase);
            bl = false;
        }
    }
}

