/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.report.AbstractReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterException;

public abstract class AbstractTextReporter
extends AbstractReporter {
    protected static final String BRIEF = "brief";
    protected static final String PLAIN = "plain";
    protected static final String SUMMARY = "summary";
    protected PrintWriter writer;
    private static final String TEST_SET_COMPLETED_PREFIX = "Tests run: ";
    private final String format;
    private List testResults;

    protected AbstractTextReporter(ReporterConfiguration reporterConfiguration, String format) {
        super(reporterConfiguration);
        this.format = format;
    }

    protected AbstractTextReporter(PrintWriter writer, String format, ReporterConfiguration reporterConfiguration) {
        super(reporterConfiguration);
        this.writer = writer;
        this.format = format;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void writeMessage(String message) {
        if (this.writer != null) {
            this.writer.println(message);
            this.writer.flush();
        }
    }

    public void writeDetailMessage(String message) {
        this.writeMessage(message);
    }

    public void testSucceeded(ReportEntry report) {
        super.testSucceeded(report);
        if (PLAIN.equals(this.format)) {
            this.testResults.add(this.getElapsedTimeSummary(report));
        }
    }

    public void testSkipped(ReportEntry report) {
        super.testSkipped(report);
        if (PLAIN.equals(this.format)) {
            this.testResults.add(report.getName() + " skipped");
        }
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        super.testError(report, stdOut, stdErr);
        this.testResults.add(this.getOutput(report, "ERROR"));
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        super.testFailed(report, stdOut, stdErr);
        this.testResults.add(this.getOutput(report, "FAILURE"));
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        this.testResults = new ArrayList();
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
        super.testSetCompleted(report);
        this.writeMessage(this.getTestSetSummary(report));
        if (this.format.equals(BRIEF) || this.format.equals(PLAIN)) {
            Iterator i = this.testResults.iterator();
            while (i.hasNext()) {
                this.writeMessage((String)i.next());
            }
        }
    }

    protected String getTestSetSummary(ReportEntry report) {
        StringBuffer buf = new StringBuffer();
        buf.append(TEST_SET_COMPLETED_PREFIX);
        buf.append(this.completedCount);
        buf.append(", Failures: ");
        buf.append(this.failures);
        buf.append(", Errors: ");
        buf.append(this.errors);
        buf.append(", Skipped: ");
        buf.append(this.skipped);
        buf.append(", Time elapsed: ");
        int elapsed = report.getElapsed() != null ? report.getElapsed() : (int)(System.currentTimeMillis() - this.testSetStartTime);
        buf.append(this.elapsedTimeAsString(elapsed));
        buf.append(" sec");
        if (this.failures > 0 || this.errors > 0) {
            buf.append(" <<< FAILURE!");
        }
        return buf.toString();
    }

    protected String getElapsedTimeSummary(ReportEntry report) {
        StringBuffer reportContent = new StringBuffer();
        long runTime = this.getActualRunTime(report);
        reportContent.append(report.getName());
        reportContent.append("  Time elapsed: ");
        reportContent.append(this.elapsedTimeAsString(runTime));
        reportContent.append(" sec");
        return reportContent.toString();
    }

    protected String getOutput(ReportEntry report, String msg) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getElapsedTimeSummary(report));
        buf.append("  <<< ").append(msg).append("!").append(NL);
        buf.append(this.getStackTrace(report));
        return buf.toString();
    }

    public static boolean isTestSetCompletedMessage(String message) {
        return message.startsWith(TEST_SET_COMPLETED_PREFIX);
    }

    public void reset() {
        super.reset();
        if (this.writer != null) {
            this.writer.flush();
        }
    }
}

