/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.changelog;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.changelog.PerforceChangesConsumer;
import org.apache.maven.scm.provider.perforce.command.changelog.PerforceDescribeConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceChangeLogCommand
extends AbstractChangeLogCommand
implements PerforceCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion, String datePattern) throws ScmException {
        return this.executeChangeLogCommand(repo, fileSet, null, null, null, datePattern, startVersion, endVersion);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        if (branch != null && StringUtils.isNotEmpty((String)branch.getName())) {
            throw new ScmException("This SCM doesn't support branches.");
        }
        return this.executeChangeLogCommand(repo, fileSet, startDate, endDate, branch, datePattern, null, null);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern, ScmVersion startVersion, ScmVersion endVersion) throws ScmException {
        PerforceDescribeConsumer describeConsumer;
        Commandline cl;
        block10: {
            PerforceChangesConsumer consumer;
            String location;
            PerforceScmProviderRepository p4repo;
            block9: {
                p4repo = (PerforceScmProviderRepository)repo;
                String clientspec = PerforceScmProvider.getClientspecName(this.getLogger(), p4repo, fileSet.getBasedir());
                cl = PerforceChangeLogCommand.createCommandLine(p4repo, fileSet.getBasedir(), clientspec, null, startDate, endDate, startVersion, endVersion);
                location = PerforceScmProvider.getRepoPath(this.getLogger(), p4repo, fileSet.getBasedir());
                consumer = new PerforceChangesConsumer(this.getLogger());
                try {
                    CommandLineUtils.StringStreamConsumer err;
                    int exitCode;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
                    }
                    if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)(err = new CommandLineUtils.StringStreamConsumer()))) != 0) {
                        String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                        StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                        msg.append('\n');
                        msg.append("Command line was:" + cmdLine);
                        throw new CommandLineException(msg.toString());
                    }
                }
                catch (CommandLineException e) {
                    if (!this.getLogger().isErrorEnabled()) break block9;
                    this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                }
            }
            List changes = consumer.getChanges();
            cl = PerforceScmProvider.createP4Command(p4repo, fileSet.getBasedir());
            cl.createArg().setValue("describe");
            cl.createArg().setValue("-s");
            for (int i = 0; i < changes.size(); ++i) {
                cl.createArg().setValue((String)changes.get(i));
            }
            describeConsumer = new PerforceDescribeConsumer(location, datePattern, this.getLogger());
            try {
                CommandLineUtils.StringStreamConsumer err;
                int exitCode;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
                }
                if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)describeConsumer, (StreamConsumer)(err = new CommandLineUtils.StringStreamConsumer()))) != 0) {
                    String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                    StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                    msg.append('\n');
                    msg.append("Command line was:" + cmdLine);
                    throw new CommandLineException(msg.toString());
                }
            }
            catch (CommandLineException e) {
                if (!this.getLogger().isErrorEnabled()) break block10;
                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
            }
        }
        ChangeLogSet cls = new ChangeLogSet(describeConsumer.getModifications(), null, null);
        cls.setStartVersion(startVersion);
        cls.setEndVersion(endVersion);
        return new ChangeLogScmResult(cl.toString(), cls);
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, String clientspec, ScmBranch branch, Date startDate, Date endDate, ScmVersion startVersion, ScmVersion endVersion) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd:HH:mm:ss");
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        if (clientspec != null) {
            command.createArg().setValue("-c");
            command.createArg().setValue(clientspec);
        }
        command.createArg().setValue("changes");
        command.createArg().setValue("-t");
        StringBuffer fileSpec = new StringBuffer("...");
        if (startDate != null) {
            fileSpec.append("@").append(dateFormat.format(startDate)).append(",");
            if (endDate != null) {
                fileSpec.append(dateFormat.format(endDate));
            } else {
                fileSpec.append("now");
            }
        }
        if (startVersion != null) {
            fileSpec.append("@").append(startVersion.getName()).append(",");
            if (endVersion != null) {
                fileSpec.append(endVersion.getName());
            } else {
                fileSpec.append("now");
            }
        }
        command.createArg().setValue(fileSpec.toString());
        return command;
    }
}

