/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseUtil {
    public static final String RELEASE_POMv4 = "release-pom.xml";
    public static final String POMv4 = "pom.xml";
    private static final String FS = File.separator;
    public static final String LS = System.getProperty("line.separator");

    private ReleaseUtil() {
    }

    public static MavenProject getRootProject(List<MavenProject> reactorProjects) {
        MavenProject project = reactorProjects.get(0);
        for (MavenProject currentProject : reactorProjects) {
            if (!currentProject.isExecutionRoot()) continue;
            project = currentProject;
            break;
        }
        return project;
    }

    public static File getStandardPom(MavenProject project) {
        if (project == null) {
            return null;
        }
        File pom = project.getFile();
        if (pom == null) {
            return null;
        }
        File releasePom = ReleaseUtil.getReleasePom(project);
        if (pom.equals(releasePom)) {
            pom = new File(pom.getParent(), POMv4);
        }
        return pom;
    }

    public static File getReleasePom(MavenProject project) {
        if (project == null) {
            return null;
        }
        File pom = project.getFile();
        if (pom == null) {
            return null;
        }
        return new File(pom.getParent(), RELEASE_POMv4);
    }

    public static String readXmlFile(File file) throws IOException {
        return ReleaseUtil.readXmlFile(file, LS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readXmlFile(File file, String ls) throws IOException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)file);
            String string = ReleaseUtil.normalizeLineEndings(IOUtil.toString((Reader)reader), ls);
            return string;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public static String normalizeLineEndings(String text, String separator) {
        String norm = text;
        if (text != null) {
            norm = text.replaceAll("(\r\n)|(\n)|(\r)", separator);
        }
        return norm;
    }

    public static ReleaseDescriptor createBasedirAlignedReleaseDescriptor(ReleaseDescriptor releaseDescriptor, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        String basedir;
        try {
            basedir = ReleaseUtil.getCommonBasedir(reactorProjects);
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Exception occurred while calculating common basedir: " + e.getMessage(), e);
        }
        int parentLevels = ReleaseUtil.getBaseWorkingDirectoryParentCount(basedir, FileUtils.normalize((String)releaseDescriptor.getWorkingDirectory()));
        String url = releaseDescriptor.getScmSourceUrl();
        url = ReleaseUtil.realignScmUrl(parentLevels, url);
        ReleaseDescriptor descriptor = new ReleaseDescriptor();
        descriptor.setWorkingDirectory(basedir);
        descriptor.setScmSourceUrl(url);
        return descriptor;
    }

    public static String getCommonBasedir(List<MavenProject> reactorProjects) throws IOException {
        return ReleaseUtil.getCommonBasedir(reactorProjects, FS);
    }

    public static String getCommonBasedir(List<MavenProject> reactorProjects, String separator) throws IOException {
        String[] baseDirs = new String[reactorProjects.size()];
        int idx = 0;
        for (MavenProject p : reactorProjects) {
            String dir = p.getBasedir().getCanonicalPath();
            if (!dir.endsWith(separator)) {
                dir = dir + separator;
            }
            baseDirs[idx++] = dir;
        }
        String basedir = StringUtils.getCommonPrefix((String[])baseDirs);
        int separatorPos = basedir.lastIndexOf(separator);
        if (!basedir.endsWith(separator) && separatorPos >= 0) {
            basedir = basedir.substring(0, separatorPos);
        }
        if (basedir.endsWith(separator) && basedir.length() > 1) {
            basedir = basedir.substring(0, basedir.length() - 1);
        }
        return basedir;
    }

    public static int getBaseWorkingDirectoryParentCount(String basedir, String workingDirectory) {
        File basedirFile;
        int num = 0;
        workingDirectory = workingDirectory.toLowerCase(Locale.ENGLISH);
        basedir = basedir.toLowerCase(Locale.ENGLISH);
        File workingDirectoryFile = new File(workingDirectory, ".tmp").getParentFile();
        if (!workingDirectoryFile.equals(basedirFile = new File(basedir, ".tmp").getParentFile()) && workingDirectory.startsWith(basedir)) {
            do {
                workingDirectoryFile = workingDirectoryFile.getParentFile();
                ++num;
            } while (!workingDirectoryFile.equals(basedirFile));
        }
        return num;
    }

    public static String realignScmUrl(int parentLevels, String url) {
        if (!StringUtils.isEmpty((String)url)) {
            int index = url.length();
            String suffix = "";
            if (url.endsWith("/")) {
                --index;
                suffix = "/";
            }
            for (int i = 0; i < parentLevels && index > 0; ++i) {
                index = url.lastIndexOf(47, index - 1);
            }
            if (index > 0) {
                url = url.substring(0, index) + suffix;
            }
        }
        return url;
    }

    public static boolean isSymlink(File file) throws IOException {
        return !file.getAbsolutePath().equals(file.getCanonicalPath());
    }
}

