/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class CheckoutProjectFromScm
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        CheckOutScmResult scmResult;
        File checkoutDirectory;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult result = new ReleaseResult();
        this.logInfo(result, "Checking out the project to perform the release ...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, settings);
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            result.setResultCode(1);
            this.logError(result, e.getMessage());
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            result.setResultCode(1);
            this.logError(result, e.getMessage());
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        if (StringUtils.isEmpty((String)releaseDescriptor.getCheckoutDirectory())) {
            checkoutDirectory = new File(ReleaseUtil.getRootProject(reactorProjects).getFile().getParentFile(), "target/checkout");
            releaseDescriptor.setCheckoutDirectory(checkoutDirectory.getAbsolutePath());
        } else {
            checkoutDirectory = new File(releaseDescriptor.getCheckoutDirectory());
        }
        if (checkoutDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)checkoutDirectory);
            }
            catch (IOException e) {
                result.setResultCode(1);
                this.logError(result, e.getMessage());
                throw new ReleaseExecutionException("Unable to remove old checkout directory: " + e.getMessage(), e);
            }
        }
        checkoutDirectory.mkdirs();
        try {
            scmResult = provider.checkOut(repository, new ScmFileSet(checkoutDirectory), (ScmVersion)new ScmTag(releaseDescriptor.getScmReleaseLabel()));
        }
        catch (ScmException e) {
            result.setResultCode(1);
            this.logError(result, e.getMessage());
            throw new ReleaseExecutionException("An error is occurred in the checkout process: " + e.getMessage(), e);
        }
        releaseDescriptor.setScmRelativePathProjectDirectory(scmResult.getRelativePathProjectDirectory());
        if (!scmResult.isSuccess()) {
            result.setResultCode(1);
            this.logError(result, scmResult.getProviderMessage());
            throw new ReleaseScmCommandException("Unable to checkout from SCM", (ScmResult)scmResult);
        }
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.simulate(releaseDescriptor, settings, reactorProjects);
    }
}

