/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.scanner;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class DefaultMojoScanner
extends AbstractLogEnabled
implements MojoScanner {
    private Map mojoDescriptorExtractors;

    public DefaultMojoScanner(Map extractors) {
        this.mojoDescriptorExtractors = extractors;
        this.enableLogging((Logger)new ConsoleLogger(1, "standalone-scanner-logger"));
    }

    public DefaultMojoScanner() {
    }

    public void populatePluginDescriptor(MavenProject project, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        Logger logger = this.getLogger();
        logger.debug("Using " + this.mojoDescriptorExtractors.size() + " extractors.");
        Iterator it = this.mojoDescriptorExtractors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String language = (String)entry.getKey();
            MojoDescriptorExtractor extractor = (MojoDescriptorExtractor)entry.getValue();
            logger.debug("Applying extractor for language: " + language);
            List extractorDescriptors = extractor.execute(project, pluginDescriptor);
            logger.debug("Extractor for language: " + language + " found " + extractorDescriptors.size() + " mojo descriptors.");
            Iterator descriptorIt = extractorDescriptors.iterator();
            while (descriptorIt.hasNext()) {
                MojoDescriptor descriptor = (MojoDescriptor)descriptorIt.next();
                logger.debug("Adding mojo: " + descriptor + " to plugin descriptor.");
                descriptor.setPluginDescriptor(pluginDescriptor);
                pluginDescriptor.addMojo(descriptor);
            }
        }
    }
}

