/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.rio.ical;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Resources;
import net.fortuna.ical4j.model.property.Trigger;
import org.apache.marmotta.commons.sesame.rio.ical.ICalFormat;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFParserBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICalParser
extends RDFParserBase {
    private static Logger log = LoggerFactory.getLogger(ICalParser.class);
    private static final SimpleDateFormat DF_DIGITS = new SimpleDateFormat("yyyyMMdd-hhmmss");
    public static final String NS_ICAL = "http://www.w3.org/2002/12/cal/icaltzd#";
    public static final String NS_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String NS_GEO = "http://www.w3.org/2003/01/geo/wgs84_pos#";
    private ValueFactory valueFactory;

    public ICalParser() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public ICalParser(ValueFactory valueFactory) {
        super(valueFactory);
        this.valueFactory = valueFactory;
    }

    public void setValueFactory(ValueFactory valueFactory) {
        super.setValueFactory(valueFactory);
        this.valueFactory = valueFactory;
    }

    public RDFFormat getRDFFormat() {
        return ICalFormat.FORMAT;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        Preconditions.checkNotNull((Object)baseURI);
        this.setBaseURI(baseURI);
        try {
            this.parseCalendar(new CalendarBuilder().build(in));
        }
        catch (ParserException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        Preconditions.checkNotNull((Object)baseURI);
        this.setBaseURI(baseURI);
        try {
            this.parseCalendar(new CalendarBuilder().build(reader));
        }
        catch (ParserException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    private void parseCalendar(Calendar calendar) throws RDFParseException, RDFHandlerException, UnsupportedEncodingException {
        for (Object component : calendar.getComponents()) {
            if (component instanceof VEvent) {
                this.parseEvent((VEvent)component);
                continue;
            }
            if (component instanceof VJournal) {
                this.parseJournal((VJournal)component);
                continue;
            }
            if (component instanceof VAlarm) {
                this.parseAlarm((VAlarm)component);
                continue;
            }
            if (component instanceof VFreeBusy) {
                this.parseFreeBusy((VFreeBusy)component);
                continue;
            }
            if (!(component instanceof VToDo)) continue;
            this.parseToDo((VToDo)component);
        }
    }

    private void parseEvent(VEvent event) throws RDFParseException, RDFHandlerException, UnsupportedEncodingException {
        log.debug("parsing event: {}", (Object)event.getUid());
        String uriBase = "";
        uriBase = event.getUid() != null ? event.getUid().getValue() : UUID.randomUUID().toString();
        if (event.getRecurrenceId() != null) {
            uriBase = uriBase + "-" + DF_DIGITS.format((Date)event.getRecurrenceId().getDate());
        }
        if (event.getSequence() != null) {
            uriBase = uriBase + "-" + event.getSequence().getSequenceNo();
        }
        URI r_event = this.resolveURI(uriBase);
        URI t_vevent = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#Vevent");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_event, p_type, (Value)t_vevent));
        this.parseCalendarComponent((CalendarComponent)event, (Resource)r_event);
    }

    private void parseJournal(VJournal journal) throws RDFParseException, RDFHandlerException, UnsupportedEncodingException {
        log.debug("parsing journal: {}", (Object)journal.getUid());
        String uriBase = "";
        uriBase = journal.getUid() != null ? journal.getUid().getValue() : UUID.randomUUID().toString();
        if (journal.getRecurrenceId() != null) {
            uriBase = uriBase + "-" + DF_DIGITS.format((Date)journal.getRecurrenceId().getDate());
        }
        if (journal.getSequence() != null) {
            uriBase = uriBase + "-" + journal.getSequence().getSequenceNo();
        }
        URI r_event = this.resolveURI(uriBase);
        URI t_vevent = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#Vjournal");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_event, p_type, (Value)t_vevent));
        this.parseCalendarComponent((CalendarComponent)journal, (Resource)r_event);
    }

    private void parseAlarm(VAlarm alarm) throws RDFParseException, RDFHandlerException, UnsupportedEncodingException {
        log.debug("parsing alarm");
        URI r_event = this.resolveURI(UUID.randomUUID().toString());
        URI t_vevent = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#Valarm");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_event, p_type, (Value)t_vevent));
        this.parseCalendarComponent((CalendarComponent)alarm, (Resource)r_event);
    }

    private void parseFreeBusy(VFreeBusy freeBusy) throws RDFParseException, RDFHandlerException, UnsupportedEncodingException {
        log.debug("parsing free/busy: {}", (Object)freeBusy.getUid());
        URI r_event = freeBusy.getUid() != null ? this.resolveURI(freeBusy.getUid().getValue()) : this.resolveURI(UUID.randomUUID().toString());
        URI t_vevent = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#Vfreebusy");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_event, p_type, (Value)t_vevent));
        this.parseCalendarComponent((CalendarComponent)freeBusy, (Resource)r_event);
    }

    private void parseToDo(VToDo toDo) throws RDFParseException, RDFHandlerException, UnsupportedEncodingException {
        log.debug("parsing todo: {}", (Object)toDo.getUid());
        URI r_event = toDo.getUid() != null ? this.resolveURI(toDo.getUid().getValue()) : this.resolveURI(UUID.randomUUID().toString());
        URI t_vevent = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#Vtodo");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_event, p_type, (Value)t_vevent));
        this.parseCalendarComponent((CalendarComponent)toDo, (Resource)r_event);
    }

    private void parseCalendarComponent(CalendarComponent component, Resource resource) throws RDFHandlerException, RDFParseException, UnsupportedEncodingException {
        if (component.getProperty("ATTACH") != null) {
            Attach attach = (Attach)component.getProperty("ATTACH");
            if (attach.getUri() != null) {
                URI r_attach = this.createURI(URLDecoder.decode(attach.getUri().toString(), "UTF-8"));
                URI p_attach = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#attach");
                this.rdfHandler.handleStatement(this.createStatement(resource, p_attach, (Value)r_attach));
            } else {
                log.warn("calendar entry: binary attachments not supported!");
            }
        }
        if (component.getProperty("CATEGORIES") != null) {
            Categories categories = (Categories)component.getProperty("CATEGORIES");
            URI p_categories = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#categories");
            for (String value : categories.getCategories()) {
                Literal v_categories = this.createLiteral(value, null, null);
                this.rdfHandler.handleStatement(this.createStatement(resource, p_categories, (Value)v_categories));
            }
        }
        this.createStringProperty(component, resource, "CLASS", "http://www.w3.org/2002/12/cal/icaltzd#class");
        this.createStringProperty(component, resource, "COMMENT", "http://www.w3.org/2002/12/cal/icaltzd#comment");
        this.createStringProperty(component, resource, "DESCRIPTION", "http://www.w3.org/2002/12/cal/icaltzd#description");
        if (component.getProperty("GEO") != null) {
            Geo geo = (Geo)component.getProperty("GEO");
            URI p_geo = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#geo");
            this.createLocation(resource, p_geo, geo);
        }
        this.createStringProperty(component, resource, "LOCATION", "http://www.w3.org/2002/12/cal/icaltzd#location");
        this.createIntProperty(component, resource, "PERCENT-COMPLETE", "http://www.w3.org/2002/12/cal/icaltzd#percentComplete");
        this.createIntProperty(component, resource, "PRIORITY", "http://www.w3.org/2002/12/cal/icaltzd#priority");
        if (component.getProperty("RESOURCES") != null) {
            Resources resources = (Resources)component.getProperty("RESOURCES");
            URI p_resources = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#resources");
            for (String value : resources.getResources()) {
                Literal v_resources = this.createLiteral(value, null, null);
                this.rdfHandler.handleStatement(this.createStatement(resource, p_resources, (Value)v_resources));
            }
        }
        this.createStringProperty(component, resource, "STATUS", "http://www.w3.org/2002/12/cal/icaltzd#status");
        this.createStringProperty(component, resource, "SUMMARY", "http://www.w3.org/2002/12/cal/icaltzd#summary");
        this.createDateProperty((Property)((DateProperty)component.getProperty("COMPLETED")), resource, "http://www.w3.org/2002/12/cal/icaltzd#completed");
        this.createDateProperty((Property)((DateProperty)component.getProperty("DUE")), resource, "http://www.w3.org/2002/12/cal/icaltzd#due");
        this.createDateProperty((Property)((DateProperty)component.getProperty("DTEND")), resource, "http://www.w3.org/2002/12/cal/icaltzd#dtend");
        this.createDateProperty((Property)((DateProperty)component.getProperty("DTSTART")), resource, "http://www.w3.org/2002/12/cal/icaltzd#dtstart");
        if (component.getProperty("DURATION") != null) {
            net.fortuna.ical4j.model.property.Duration duration = (net.fortuna.ical4j.model.property.Duration)component.getProperty("DURATION");
            URI p_duration = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#duration");
            try {
                Duration dur = DatatypeFactory.newInstance().newDuration(duration.getDuration().getTime(new Date(0L)).getTime());
                Literal v_duration = this.createLiteral(dur.toString(), null, this.createURI(dur.getXMLSchemaType().toString()));
                this.rdfHandler.handleStatement(this.createStatement(resource, p_duration, (Value)v_duration));
            }
            catch (DatatypeConfigurationException e) {
                log.warn("calendar entry: error while parsing duration");
            }
        }
        this.createStringProperty(component, resource, "TRANSP", "http://www.w3.org/2002/12/cal/icaltzd#transp");
        URI p_attendee = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#attendee");
        for (Attendee attendee : component.getProperties("ATTENDEE")) {
            if (attendee.getCalAddress() != null) {
                URI v_attendee = this.createURI(attendee.getCalAddress().toString());
                this.rdfHandler.handleStatement(this.createStatement(resource, p_attendee, (Value)v_attendee));
                continue;
            }
            log.warn("attendee without calendar address: {}", (Object)attendee);
        }
        this.createStringProperty(component, resource, "CONTACT", "http://www.w3.org/2002/12/cal/icaltzd#contact");
        if (component.getProperty("ORGANIZER") != null) {
            Organizer organizer = (Organizer)component.getProperty("ORGANIZER");
            URI p_organizer = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#organizer");
            if (organizer.getCalAddress() != null) {
                URI v_organizer = this.createURI(organizer.getCalAddress().toString());
                this.rdfHandler.handleStatement(this.createStatement(resource, p_organizer, (Value)v_organizer));
            }
        }
        this.createStringProperty(component, resource, "RELATED-TO", "http://www.w3.org/2002/12/cal/icaltzd#relatedTo");
        this.createUrlProperty(component, resource, "URL", "http://www.w3.org/2002/12/cal/icaltzd#url");
        this.createStringProperty(component, resource, "UID", "http://www.w3.org/2002/12/cal/icaltzd#uid");
        Iterator it = component.getProperties("EXDATE").iterator();
        while (it.hasNext()) {
            this.createDateProperty((Property)it.next(), resource, "http://www.w3.org/2002/12/cal/icaltzd#exdate");
        }
        it = component.getProperties("EXRULE").iterator();
        while (it.hasNext()) {
            this.createStringProperty((Property)it.next(), resource, "http://www.w3.org/2002/12/cal/icaltzd#exrule");
        }
        it = component.getProperties("RDATE").iterator();
        while (it.hasNext()) {
            this.createDateProperty((Property)((DateProperty)it.next()), resource, "http://www.w3.org/2002/12/cal/icaltzd#rdate");
        }
        it = component.getProperties("RRULE").iterator();
        while (it.hasNext()) {
            this.createStringProperty((Property)it.next(), resource, "http://www.w3.org/2002/12/cal/icaltzd#rrule");
        }
        if (component.getProperty("TRIGGER") != null) {
            Trigger duration = (Trigger)component.getProperty("TRIGGER");
            URI p_duration = this.createURI("http://www.w3.org/2002/12/cal/icaltzd#trigger");
            try {
                Duration dur = DatatypeFactory.newInstance().newDuration(duration.getDuration().getTime(new Date(0L)).getTime());
                Literal v_duration = this.createLiteral(dur.toString(), null, this.createURI(dur.getXMLSchemaType().toString()));
                this.rdfHandler.handleStatement(this.createStatement(resource, p_duration, (Value)v_duration));
            }
            catch (DatatypeConfigurationException e) {
                log.warn("calendar entry: error while parsing duration");
            }
        }
        this.createDateProperty((Property)((DateProperty)component.getProperty("CREATED")), resource, "http://www.w3.org/2002/12/cal/icaltzd#created");
        this.createDateProperty((Property)((DateProperty)component.getProperty("DTSTAMP")), resource, "http://www.w3.org/2002/12/cal/icaltzd#dtstamp");
        this.createDateProperty((Property)((DateProperty)component.getProperty("LAST-MODIFIED")), resource, "http://www.w3.org/2002/12/cal/icaltzd#lastModified");
        this.createDateProperty((Property)((DateProperty)component.getProperty("RECURRENCE-ID")), resource, "http://www.w3.org/2002/12/cal/icaltzd#recurrenceId");
        this.createIntProperty(component, resource, "SEQUENCE", "http://www.w3.org/2002/12/cal/icaltzd#sequence");
        this.createStringProperty(component, resource, "REQUEST-STATUS", "http://www.w3.org/2002/12/cal/icaltzd#requestStatus");
        this.createStringProperty(component, resource, "ACTION", "http://www.w3.org/2002/12/cal/icaltzd#action");
        this.createStringProperty(component, resource, "REPEAT", "http://www.w3.org/2002/12/cal/icaltzd#repeat");
    }

    private void createLocation(Resource uri, URI prop, Geo geo) throws RDFHandlerException, RDFParseException {
        BNode r_location = this.createBNode();
        URI t_adr = this.createURI("http://www.w3.org/2003/01/geo/wgs84_pos#Point");
        URI p_type = this.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfHandler.handleStatement(this.createStatement((Resource)r_location, p_type, (Value)t_adr));
        URI p_latitute = this.createURI("http://www.w3.org/2003/01/geo/wgs84_pos#latitude");
        URI p_longitude = this.createURI("http://www.w3.org/2003/01/geo/wgs84_pos#longitude");
        URI t_decimal = this.createURI("http://www.w3.org/2001/XMLSchema#double");
        if (geo.getLatitude() != null) {
            Literal v_latitude = this.createLiteral(geo.getLatitude().toPlainString(), null, t_decimal);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_location, p_latitute, (Value)v_latitude));
        }
        if (geo.getLongitude() != null) {
            Literal v_longitude = this.createLiteral(geo.getLongitude().toPlainString(), null, t_decimal);
            this.rdfHandler.handleStatement(this.createStatement((Resource)r_location, p_longitude, (Value)v_longitude));
        }
        this.rdfHandler.handleStatement(this.createStatement(uri, prop, (Value)r_location));
    }

    private void createStringProperty(CalendarComponent event, Resource r_event, String icalProperty, String rdfProperty) throws RDFParseException, RDFHandlerException {
        if (event.getProperty(icalProperty) != null) {
            Property description = event.getProperty(icalProperty);
            URI p_description = this.createURI(rdfProperty);
            Literal v_description = this.createLiteral(description.getValue(), null, null);
            this.rdfHandler.handleStatement(this.createStatement(r_event, p_description, (Value)v_description));
        }
    }

    private void createStringProperty(Property property, Resource r_event, String rdfProperty) throws RDFParseException, RDFHandlerException {
        if (property != null) {
            URI p_description = this.createURI(rdfProperty);
            Literal v_description = this.createLiteral(property.getValue(), null, null);
            this.rdfHandler.handleStatement(this.createStatement(r_event, p_description, (Value)v_description));
        }
    }

    private void createIntProperty(CalendarComponent event, Resource r_event, String icalProperty, String rdfProperty) throws RDFParseException, RDFHandlerException {
        if (event.getProperty(icalProperty) != null) {
            Property description = event.getProperty(icalProperty);
            URI p_description = this.createURI(rdfProperty);
            Literal v_description = this.createLiteral(description.getValue(), null, this.createURI("http://www.w3.org/2001/XMLSchema#int"));
            this.rdfHandler.handleStatement(this.createStatement(r_event, p_description, (Value)v_description));
        }
    }

    private void createDateProperty(Property property, Resource r_event, String rdfProperty) throws RDFParseException, RDFHandlerException {
        if (property != null) {
            if (property instanceof DateProperty) {
                DateProperty dateProperty = (DateProperty)property;
                URI p_dateprop = this.createURI(rdfProperty);
                Literal v_dateprop = this.valueFactory.createLiteral(ICalParser.getXMLCalendar((Date)dateProperty.getDate(), (TimeZone)dateProperty.getTimeZone()));
                this.rdfHandler.handleStatement(this.createStatement(r_event, p_dateprop, (Value)v_dateprop));
            } else if (property instanceof DateListProperty) {
                DateListProperty dateProperty = (DateListProperty)property;
                URI p_dateprop = this.createURI(rdfProperty);
                Iterator it = dateProperty.getDates().iterator();
                while (it.hasNext()) {
                    Literal v_dateprop = this.valueFactory.createLiteral(ICalParser.getXMLCalendar((Date)it.next(), (TimeZone)dateProperty.getTimeZone()));
                    this.rdfHandler.handleStatement(this.createStatement(r_event, p_dateprop, (Value)v_dateprop));
                }
            }
        }
    }

    private void createUrlProperty(CalendarComponent event, Resource r_event, String icalProperty, String rdfProperty) throws RDFParseException, RDFHandlerException {
        if (event.getProperty(icalProperty) != null) {
            Property description = event.getProperty(icalProperty);
            URI p_description = this.createURI(rdfProperty);
            URI v_description = this.createURI(description.getValue());
            this.rdfHandler.handleStatement(this.createStatement(r_event, p_description, (Value)v_description));
        }
    }

    public static Date getDate(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar getXMLCalendar(Date date, TimeZone timezone) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        if (timezone != null) {
            c.setTimeZone(timezone);
        }
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
    }
}

