/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.reasoner.webservices;

import com.google.common.base.Joiner;
import info.aduna.iteration.Iterations;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.marmotta.kiwi.reasoner.model.program.Program;
import org.apache.marmotta.platform.reasoner.services.ReasoningSailProvider;
import org.slf4j.Logger;

@ApplicationScoped
@Path(value="/reasoner/program")
@Produces(value={"application/json"})
public class ProgramWebService {
    @Inject
    private Logger log;
    @Inject
    private ReasoningSailProvider provider;

    @POST
    @Path(value="/{name}")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Response uploadProgram(@PathParam(value="name") String name, @Context HttpServletRequest request) {
        try {
            this.provider.addProgram(name, (InputStream)request.getInputStream());
            return Response.ok((Object)"program created").build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/{name}")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Response updateProgram(@PathParam(value="name") String name, @Context HttpServletRequest request) {
        try {
            this.provider.updateProgram(name, (InputStream)request.getInputStream());
            return Response.ok((Object)"program updated").build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"text/plain"})
    public Response getProgram(@PathParam(value="name") String name) {
        try {
            Program program = this.provider.getProgram(name);
            if (program == null) {
                return Response.status((int)404).entity((Object)("Could not find program with name '" + name + "'")).build();
            }
            return Response.ok((Object)program.toString()).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="/{name}")
    public Response deleteProgram(@PathParam(value="name") String name) {
        this.log.debug("Deleting reasoning program '{}'", (Object)name);
        try {
            this.provider.deleteProgram(name);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((int)404).entity((Object)("program with name " + name + " not found")).build();
        }
    }

    @GET
    @Path(value="/list")
    public Response getProgramList() {
        try {
            List programs = Iterations.asList(this.provider.listPrograms());
            ArrayList<POJOProgram> pgrs = new ArrayList<POJOProgram>();
            this.log.debug("Listing {} reasoning programs", (Object)programs.size());
            for (Program p : programs) {
                POJOProgram pr = new POJOProgram();
                pr.setName(p.getName());
                pr.setRules(Joiner.on((String)"\n").join((Iterable)p.getRules()));
                pgrs.add(pr);
            }
            return Response.ok().entity(pgrs).build();
        }
        catch (Exception ex) {
            return Response.serverError().build();
        }
    }

    private static class POJOProgram {
        String name;
        String rules;

        public POJOProgram() {
        }

        public POJOProgram(String name, String rules) {
            this.name = name;
            this.rules = rules;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRules() {
            return this.rules;
        }

        public void setRules(String rules) {
            this.rules = rules;
        }
    }
}

