/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.reasoner.services;

import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.apache.marmotta.kiwi.reasoner.engine.ReasoningConfiguration;
import org.apache.marmotta.kiwi.reasoner.model.program.Justification;
import org.apache.marmotta.kiwi.reasoner.model.program.Program;
import org.apache.marmotta.kiwi.reasoner.parser.ParseException;
import org.apache.marmotta.kiwi.reasoner.sail.KiWiReasoningSail;
import org.apache.marmotta.kiwi.transactions.api.TransactionalSail;
import org.apache.marmotta.kiwi.transactions.wrapper.TransactionalSailWrapper;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.core.api.triplestore.TransactionalSailProvider;
import org.apache.marmotta.platform.core.events.ConfigurationChangedEvent;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;

@ApplicationScoped
public class ReasoningSailProvider
implements TransactionalSailProvider {
    public static final String REASONING_ENABLED = "reasoning.enabled";
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private SesameService sesameService;
    private KiWiReasoningSail sail;

    public String getName() {
        return "KWRL Reasoner";
    }

    public TransactionalSailWrapper createSail(TransactionalSail parent) {
        ReasoningConfiguration config = new ReasoningConfiguration();
        config.setBatchSize(this.configurationService.getIntConfiguration("reasoning.batchsize", 1000));
        config.setRemoveDuplicateJustifications(this.configurationService.getBooleanConfiguration("reasoning.remove_duplicate_justifications", false));
        this.sail = new KiWiReasoningSail(parent, config);
        return this.sail;
    }

    public boolean isEnabled() {
        return this.configurationService.getBooleanConfiguration(REASONING_ENABLED, true);
    }

    public void configurationChanged(@Observes ConfigurationChangedEvent e) {
        if (e.containsChangedKey(REASONING_ENABLED)) {
            this.sesameService.shutdown();
            this.sesameService.initialise();
        } else if (e.containsChangedKeyWithPrefix("reasoning")) {
            ReasoningConfiguration config = this.sail.getConfig();
            config.setBatchSize(this.configurationService.getIntConfiguration("reasoning.batchsize", 1000));
            config.setRemoveDuplicateJustifications(this.configurationService.getBooleanConfiguration("reasoning.remove_duplicate_justifications", false));
        }
    }

    public void addProgram(String name, InputStream data) throws IOException, SailException, ParseException {
        this.sail.addProgram(name, data);
    }

    public void addProgram(Program program) throws SailException {
        this.sail.addProgram(program);
    }

    public void deleteProgram(String name) throws SailException {
        this.sail.deleteProgram(name);
    }

    public Program getProgram(String name) throws SailException {
        return this.sail.getProgram(name);
    }

    public CloseableIteration<Program, SailException> listPrograms() throws SailException {
        return this.sail.listPrograms();
    }

    public void reRunPrograms() {
        this.sail.reRunPrograms();
    }

    public void updateProgram(String name, InputStream data) throws IOException, SailException, ParseException {
        this.sail.updateProgram(name, data);
    }

    public void updateProgram(Program program) throws SailException {
        this.sail.updateProgram(program);
    }

    public CloseableIteration<Justification, SailException> justify(long tripleId) throws SailException {
        return this.sail.justify(tripleId);
    }
}

