/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.text;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;

public class StrLenFunction<Node>
extends SelectorFunction<Node> {
    private static final URI dataType = URI.create("http://www.w3.org/2001/XMLSchema#integer");

    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)("Check usage: " + this.getSignature()));
        LinkedList<Object> result = new LinkedList<Object>();
        for (Node node : args[0]) {
            String stringValue = backend.stringValue(node);
            int c = stringValue.length();
            result.add(backend.createLiteral(String.valueOf(c), null, dataType));
        }
        return result;
    }

    public String getSignature() {
        return "fn:strlen(text: Literal) : IntegerLiteralList";
    }

    public String getDescription() {
        return "returns the length of the given StringLiterals";
    }

    public String getLocalName() {
        return "strlen";
    }
}

