/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.text;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;

public class StrJoinFunction<Node>
extends SelectorFunction<Node> {
    private final StringTransformer<Node> transformer = new StringTransformer();

    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        if (args.length < 2 || args.length > 4) {
            throw new IllegalArgumentException("wrong usage: " + this.getSignature());
        }
        if (args[1].size() != 1 || args.length > 2 && args[2].size() != 1 || args.length > 3 && args[3].size() != 1) {
            throw new IllegalArgumentException("wrong usage: " + this.getSignature());
        }
        Collection<Node> nodes = args[0];
        Object join = this.transformer.transform((RDFBackend)backend, (Object)args[1].iterator().next(), (Map)null);
        String prefix = args.length > 2 ? this.transformer.transform((RDFBackend)backend, (Object)args[2].iterator().next(), (Map)null) : "";
        String suffix = args.length > 3 ? this.transformer.transform((RDFBackend)backend, (Object)args[3].iterator().next(), (Map)null) : "";
        StringBuilder sb = new StringBuilder(prefix);
        boolean first = true;
        for (Node node : nodes) {
            String string = backend.stringValue(node);
            if (!first) {
                sb.append((String)join);
            }
            sb.append(string);
            first = false;
        }
        sb.append(suffix);
        return Collections.singleton(backend.createLiteral(sb.toString()));
    }

    public String getSignature() {
        return "fn:strJoin(nodes: NodeList, separator: String [, prefix: String [, suffix: String ]]) :: LiteralList";
    }

    public String getDescription() {
        return "join the string representation of all provided nodes.";
    }

    public String getLocalName() {
        return "strJoin";
    }
}

