/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.rdf;

import info.aduna.lang.FileFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.marmotta.ldclient.exception.DataRetrievalException;
import org.apache.marmotta.ldclient.services.provider.AbstractHttpProvider;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.event.RepositoryConnectionInterceptor;
import org.openrdf.repository.event.base.InterceptingRepositoryConnectionWrapper;
import org.openrdf.repository.event.base.RepositoryConnectionInterceptorAdapter;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParserRegistry;

public abstract class AbstractRDFProvider
extends AbstractHttpProvider {
    public String[] listMimeTypes() {
        return new String[]{"application/rdf+xml", "text/rdf+n3; q=0.8", "text/turtle; q=0.6"};
    }

    public List<String> parseResponse(final String resourceUri, String requestUrl, Repository triples, InputStream in, String contentType) throws DataRetrievalException {
        RDFFormat format = (RDFFormat)RDFParserRegistry.getInstance().getFileFormatForMIMEType(contentType, (FileFormat)RDFFormat.RDFXML);
        try {
            InterceptingRepositoryConnectionWrapper con = new InterceptingRepositoryConnectionWrapper(triples, triples.getConnection());
            con.addRepositoryConnectionInterceptor((RepositoryConnectionInterceptor)new RepositoryConnectionInterceptorAdapter(){

                public boolean add(RepositoryConnection conn, Resource s, URI p, Value o, Resource ... contexts) {
                    if (s instanceof URI) {
                        return !s.stringValue().equals(resourceUri);
                    }
                    return true;
                }

                public boolean remove(RepositoryConnection conn, Resource s, URI p, Value o, Resource ... contexts) {
                    if (s instanceof URI) {
                        return !s.stringValue().equals(resourceUri);
                    }
                    return true;
                }
            });
            con.add(in, resourceUri, format, new Resource[0]);
            con.commit();
            con.close();
            return Collections.emptyList();
        }
        catch (RepositoryException e) {
            throw new DataRetrievalException("error while initializing temporary RDF store", (Throwable)e);
        }
        catch (RDFParseException e) {
            throw new DataRetrievalException("parse error while trying to parse remote RDF content", (Throwable)e);
        }
        catch (IOException e) {
            throw new DataRetrievalException("I/O error while trying to read remote RDF content", (Throwable)e);
        }
    }
}

