/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class DescribeGroupsRequestData
implements ApiMessage {
    private List<String> groups = new ArrayList<String>();
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public DescribeGroupsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public DescribeGroupsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public DescribeGroupsRequestData() {
    }

    public short apiKey() {
        return 15;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.groups.clear();
        } else {
            this.groups.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.groups.add(readable.readNullableString());
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.groups.size());
        for (String element : this.groups) {
            writable.writeString(element);
        }
    }

    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("groups");
        this.groups = new ArrayList<String>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.groups.add((String)nestedObject);
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        String[] nestedObjects = new String[this.groups.size()];
        int i = 0;
        for (String element : this.groups) {
            nestedObjects[i++] = element;
        }
        struct.set("groups", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        for (String element : this.groups) {
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)element);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeGroupsRequestData)) {
            return false;
        }
        DescribeGroupsRequestData other = (DescribeGroupsRequestData)obj;
        return !(this.groups == null ? other.groups != null : !this.groups.equals(other.groups));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groups == null ? 0 : this.groups.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DescribeGroupsRequestData(groups=" + MessageUtil.deepToString(this.groups.iterator()) + ")";
    }

    public List<String> groups() {
        return this.groups;
    }

    public DescribeGroupsRequestData setGroups(List<String> v) {
        this.groups = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("groups", (Type)new ArrayOf((Type)Type.STRING), "The names of the groups to describe")}));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

