/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiSet;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;

public class AddPartitionsToTxnResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private AddPartitionsToTxnTopicResultSet results;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AddPartitionsToTxnResponseData(Readable readable, short version) {
        this.results = new AddPartitionsToTxnTopicResultSet(0);
        this.read(readable, version);
    }

    public AddPartitionsToTxnResponseData(Struct struct, short version) {
        this.results = new AddPartitionsToTxnTopicResultSet(0);
        this.fromStruct(struct, version);
    }

    public AddPartitionsToTxnResponseData() {
        this.throttleTimeMs = 0;
        this.results = new AddPartitionsToTxnTopicResultSet(0);
    }

    public short apiKey() {
        return 24;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.results.clear(0);
        } else {
            this.results.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.results.add(new AddPartitionsToTxnTopicResult(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.results.size());
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            AddPartitionsToTxnTopicResult element = (AddPartitionsToTxnTopicResult)iterator.next();
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("results");
        this.results = new AddPartitionsToTxnTopicResultSet(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.results.add(new AddPartitionsToTxnTopicResult((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.results.size()];
        int i = 0;
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            AddPartitionsToTxnTopicResult element = (AddPartitionsToTxnTopicResult)iterator.next();
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("results", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            AddPartitionsToTxnTopicResult element = (AddPartitionsToTxnTopicResult)iterator.next();
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddPartitionsToTxnResponseData)) {
            return false;
        }
        AddPartitionsToTxnResponseData other = (AddPartitionsToTxnResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals((Object)other.results));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public String toString() {
        return "AddPartitionsToTxnResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString((Iterator)this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public AddPartitionsToTxnTopicResultSet results() {
        return this.results;
    }

    public AddPartitionsToTxnResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AddPartitionsToTxnResponseData setResults(AddPartitionsToTxnTopicResultSet v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", (Type)new ArrayOf((Type)AddPartitionsToTxnTopicResult.SCHEMA_0), "The results for each topic.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class AddPartitionsToTxnTopicResultSet
    extends ImplicitLinkedHashMultiSet<AddPartitionsToTxnTopicResult> {
        public AddPartitionsToTxnTopicResultSet() {
        }

        public AddPartitionsToTxnTopicResultSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnTopicResultSet(Iterator<AddPartitionsToTxnTopicResult> iterator) {
            super(iterator);
        }

        public AddPartitionsToTxnTopicResult find(String name) {
            AddPartitionsToTxnTopicResult key = new AddPartitionsToTxnTopicResult();
            key.setName(name);
            return (AddPartitionsToTxnTopicResult)this.find(key);
        }

        public List<AddPartitionsToTxnTopicResult> findAll(String name) {
            AddPartitionsToTxnTopicResult key = new AddPartitionsToTxnTopicResult();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class AddPartitionsToTxnPartitionResultSet
    extends ImplicitLinkedHashMultiSet<AddPartitionsToTxnPartitionResult> {
        public AddPartitionsToTxnPartitionResultSet() {
        }

        public AddPartitionsToTxnPartitionResultSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AddPartitionsToTxnPartitionResultSet(Iterator<AddPartitionsToTxnPartitionResult> iterator) {
            super(iterator);
        }

        public AddPartitionsToTxnPartitionResult find(int partitionIndex) {
            AddPartitionsToTxnPartitionResult key = new AddPartitionsToTxnPartitionResult();
            key.setPartitionIndex(partitionIndex);
            return (AddPartitionsToTxnPartitionResult)this.find(key);
        }

        public List<AddPartitionsToTxnPartitionResult> findAll(int partitionIndex) {
            AddPartitionsToTxnPartitionResult key = new AddPartitionsToTxnPartitionResult();
            key.setPartitionIndex(partitionIndex);
            return this.findAll(key);
        }
    }

    public static class AddPartitionsToTxnPartitionResult
    implements Message,
    ImplicitLinkedHashSet.Element {
        private int partitionIndex;
        private short errorCode;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AddPartitionsToTxnPartitionResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public AddPartitionsToTxnPartitionResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public AddPartitionsToTxnPartitionResult() {
            this.partitionIndex = 0;
            this.errorCode = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
        }

        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
        }

        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 4;
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnPartitionResult)) {
                return false;
            }
            AddPartitionsToTxnPartitionResult other = (AddPartitionsToTxnPartitionResult)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        public String toString() {
            return "AddPartitionsToTxnPartitionResult(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public AddPartitionsToTxnPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public AddPartitionsToTxnPartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition indexes."), new Field("error_code", (Type)Type.INT16, "The response error code.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class AddPartitionsToTxnTopicResult
    implements Message,
    ImplicitLinkedHashSet.Element {
        private String name;
        private AddPartitionsToTxnPartitionResultSet results;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AddPartitionsToTxnTopicResult(Readable readable, short version) {
            this.results = new AddPartitionsToTxnPartitionResultSet(0);
            this.read(readable, version);
        }

        public AddPartitionsToTxnTopicResult(Struct struct, short version) {
            this.results = new AddPartitionsToTxnPartitionResultSet(0);
            this.fromStruct(struct, version);
        }

        public AddPartitionsToTxnTopicResult() {
            this.name = "";
            this.results = new AddPartitionsToTxnPartitionResultSet(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.results.clear(0);
            } else {
                this.results.clear(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    this.results.add(new AddPartitionsToTxnPartitionResult(readable, version));
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.results.size());
            Iterator iterator = this.results.iterator();
            while (iterator.hasNext()) {
                AddPartitionsToTxnPartitionResult element = (AddPartitionsToTxnPartitionResult)iterator.next();
                element.write(writable, version);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("results");
            this.results = new AddPartitionsToTxnPartitionResultSet(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.results.add(new AddPartitionsToTxnPartitionResult((Struct)nestedObject, version));
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.results.size()];
            int i = 0;
            Iterator iterator = this.results.iterator();
            while (iterator.hasNext()) {
                AddPartitionsToTxnPartitionResult element = (AddPartitionsToTxnPartitionResult)iterator.next();
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("results", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            size += 4;
            Iterator iterator = this.results.iterator();
            while (iterator.hasNext()) {
                AddPartitionsToTxnPartitionResult element = (AddPartitionsToTxnPartitionResult)iterator.next();
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddPartitionsToTxnTopicResult)) {
                return false;
            }
            AddPartitionsToTxnTopicResult other = (AddPartitionsToTxnTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AddPartitionsToTxnTopicResult(name='" + this.name + "', results=" + MessageUtil.deepToString((Iterator)this.results.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public AddPartitionsToTxnPartitionResultSet results() {
            return this.results;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public AddPartitionsToTxnTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public AddPartitionsToTxnTopicResult setResults(AddPartitionsToTxnPartitionResultSet v) {
            this.results = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("results", (Type)new ArrayOf((Type)AddPartitionsToTxnPartitionResult.SCHEMA_0), "The results for each partition")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

