/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.primitive;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxX;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxXConfig;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.annotation.LabelPosition;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionUtil;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BooleanPanel
extends ScalarPanelAbstract {
    private static final CheckBoxXConfig THREE_STATE_CONFIG = new CheckBoxXConfig().withSize(CheckBoxXConfig.Sizes.xs).withEnclosedLabel(false).withIconChecked("<i class='fa fa-fw fa-check'></i>").withIconNull("<i class='fa fa-fw fa-square'></i>");
    private static final CheckBoxXConfig TWO_STATE_CONFIG = new CheckBoxXConfig(THREE_STATE_CONFIG).withThreeState(false);
    private static final long serialVersionUID = 1L;
    private CheckBoxX checkBox;

    public BooleanPanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected MarkupContainer addComponentForRegular() {
        String describedAs;
        String name = ((ScalarModel)this.getModel()).getName();
        this.checkBox = this.createCheckBox("scalarValue");
        this.checkBox.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormGroup labelIfRegular = new FormGroup("scalarIfRegular", (FormComponent<?>)this.checkBox);
        labelIfRegular.add(new Component[]{this.checkBox});
        if (((ScalarModel)this.getModel()).isRequired()) {
            labelIfRegular.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        if ((describedAs = ((ScalarModel)this.getModel()).getDescribedAs()) != null) {
            labelIfRegular.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)describedAs)))});
        }
        Label scalarName = new Label("scalarName", this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.checkBox));
        labelIfRegular.add(new Component[]{scalarName});
        NamedFacet namedFacet = (NamedFacet)((ScalarModel)this.getModel()).getFacet(NamedFacet.class);
        if (namedFacet != null) {
            scalarName.setEscapeModelStrings(namedFacet.escaped());
        }
        List<LinkAndLabel> entityActions = EntityActionUtil.getEntityActionLinksForAssociation(this.scalarModel, this.getDeploymentType());
        this.addPositioningCssTo((MarkupContainer)labelIfRegular, entityActions);
        this.addOrReplace(new Component[]{labelIfRegular});
        this.addFeedbackTo((MarkupContainer)labelIfRegular, (Component)this.checkBox);
        this.addEntityActionLinksBelowAndRight((MarkupContainer)labelIfRegular, entityActions);
        return labelIfRegular;
    }

    @Override
    protected Component addComponentForCompact() {
        CheckBoxX component = this.createCheckBox("scalarIfCompact");
        this.addOrReplace(new Component[]{component});
        return component;
    }

    private CheckBoxX createCheckBox(String id) {
        CheckBoxX checkBox = new CheckBoxX(id, (IModel)new Model<Boolean>(){
            private static final long serialVersionUID = 1L;

            public Boolean getObject() {
                ScalarModel model = (ScalarModel)BooleanPanel.this.getModel();
                ObjectAdapter adapter = (ObjectAdapter)model.getObject();
                return adapter != null ? (Boolean)adapter.getObject() : null;
            }

            public void setObject(Boolean object) {
                ObjectAdapter adapter = BooleanPanel.this.getAdapterManager().adapterFor((Object)object);
                ((ScalarModel)BooleanPanel.this.getModel()).setObject(adapter);
            }
        }){

            public CheckBoxXConfig getConfig() {
                return ((ScalarModel)BooleanPanel.this.getModel()).isRequired() ? TWO_STATE_CONFIG : THREE_STATE_CONFIG;
            }
        };
        checkBox.setOutputMarkupId(true);
        checkBox.setEnabled(false);
        ObjectSpecification objectSpecification = ((ScalarModel)this.getModel()).getTypeOfSpecification();
        if (objectSpecification.getFullIdentifier().equals("boolean") && ((ScalarModel)this.getModel()).getObject() == null) {
            ((ScalarModel)this.getModel()).setObject(this.getAdapterManager().adapterFor((Object)false));
        }
        return checkBox;
    }

    @Override
    protected void onBeforeRenderWhenEnabled() {
        super.onBeforeRenderWhenEnabled();
        this.checkBox.setEnabled(true);
    }

    @Override
    protected void onBeforeRenderWhenViewMode() {
        super.onBeforeRenderWhenViewMode();
        this.checkBox.setEnabled(false);
    }

    @Override
    protected void onBeforeRenderWhenDisabled(String disableReason) {
        super.onBeforeRenderWhenDisabled(disableReason);
        this.checkBox.setEnabled(false);
    }

    @Override
    protected void addFormComponentBehavior(Behavior behavior) {
        this.checkBox.add(new Behavior[]{behavior});
    }

    public String getVariation() {
        LabelAtFacet facet = (LabelAtFacet)((ScalarModel)this.getModel()).getFacet(LabelAtFacet.class);
        String variation = facet != null && LabelPosition.RIGHT == facet.label() ? "labelRightPosition" : super.getVariation();
        return variation;
    }
}

