/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jodatime;

import java.util.Locale;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaAbstract;
import org.apache.wicket.util.convert.ConversionException;
import org.joda.time.LocalDateTime;

public class DateConverterForJodaLocalDateTime
extends DateConverterForJodaAbstract<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJodaLocalDateTime(WicketViewerSettings settings, int adjustBy) {
        this(settings.getDatePattern(), settings.getDateTimePattern(), settings.getDateTimePattern(), adjustBy);
    }

    private DateConverterForJodaLocalDateTime(String datePattern, String dateTimePattern, String datePickerPattern, int adjustBy) {
        super(LocalDateTime.class, datePattern, dateTimePattern, datePickerPattern, adjustBy);
    }

    @Override
    protected LocalDateTime doConvertToObject(String value, Locale locale) {
        LocalDateTime dateTime = this.convert(value);
        LocalDateTime adjustedDateTime = dateTime.minusDays(this.adjustBy);
        return adjustedDateTime;
    }

    private LocalDateTime convert(String value) {
        try {
            LocalDateTime dateTime = this.getFormatterForDateTimePattern().parseLocalDateTime(value);
            return dateTime;
        }
        catch (IllegalArgumentException ex) {
            try {
                LocalDateTime dateTime = this.getFormatterForDatePattern().parseLocalDateTime(value);
                return dateTime;
            }
            catch (IllegalArgumentException ex2) {
                throw new ConversionException("Cannot convert into a date/time", (Throwable)ex);
            }
        }
    }

    @Override
    protected String doConvertToString(LocalDateTime value, Locale locale) {
        return value.plusDays(this.adjustBy).toString(this.getFormatterForDateTimePattern());
    }
}

