/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath;

import java.math.BigInteger;
import java.util.Locale;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.AbstractIntegerConverter;
import org.apache.wicket.util.string.Strings;

public final class BigIntegerConverter
extends AbstractIntegerConverter<BigInteger> {
    private static final long serialVersionUID = 1L;
    public static final IConverter<BigInteger> INSTANCE = new BigIntegerConverter();

    public BigInteger convertToObject(String value, Locale locale) throws ConversionException {
        if (Strings.isEmpty((CharSequence)value)) {
            return null;
        }
        Number number = this.parse(value, -1.7976931348623157E308, Double.MAX_VALUE, locale);
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf(number.longValue());
        }
        if (number instanceof Integer) {
            return BigInteger.valueOf(number.intValue());
        }
        return new BigInteger(value);
    }

    protected Class<BigInteger> getTargetType() {
        return BigInteger.class;
    }
}

