/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection.bulk;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.applib.filter.Filters;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;

public class BulkActionsHelper
implements Serializable {
    private final EntityCollectionModel model;
    private static final long serialVersionUID = 1L;
    private static final Predicate<ObjectAction> BULK = Filters.asPredicate((Filter)ObjectAction.Filters.bulk());

    public BulkActionsHelper(EntityCollectionModel model) {
        this.model = model;
    }

    private EntityCollectionModel getModel() {
        return this.model;
    }

    public List<ObjectAction> getBulkActions() {
        EntityCollectionModel model = this.getModel();
        if (model.isParented()) {
            return Collections.emptyList();
        }
        ObjectSpecification typeSpec = model.getTypeOfSpecification();
        List objectActions = typeSpec.getObjectActions(ActionType.USER, Contributed.INCLUDED, Filters.any());
        if (this.isExploring() || this.isPrototyping()) {
            List explorationActions = typeSpec.getObjectActions(ActionType.EXPLORATION, Contributed.INCLUDED, Filters.any());
            List prototypeActions = typeSpec.getObjectActions(ActionType.PROTOTYPE, Contributed.INCLUDED, Filters.any());
            objectActions.addAll(explorationActions);
            objectActions.addAll(prototypeActions);
        }
        if (this.isDebugMode()) {
            List debugActions = typeSpec.getObjectActions(ActionType.DEBUG, Contributed.INCLUDED, Filters.any());
            objectActions.addAll(debugActions);
        }
        List flattenedActions = objectActions;
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)flattenedActions, BULK));
    }

    public boolean isExploring() {
        return IsisContext.getDeploymentType().isExploring();
    }

    public boolean isPrototyping() {
        return IsisContext.getDeploymentType().isPrototyping();
    }

    protected boolean isDebugMode() {
        return true;
    }
}

