/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actions;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.hints.IsisActionCompletedEvent;
import org.apache.isis.viewer.wicket.model.mementos.ActionParameterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionExecutor;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionprompt.ActionPromptModalWindow;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelSubscriber;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldValueModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.FormFeedbackPanel;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlUtil;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ActionParametersFormPanel
extends PanelAbstract<ActionModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_OK_BUTTON = "okButton";
    private static final String ID_CANCEL_BUTTON = "cancelButton";
    private static final String ID_ACTION_PARAMETERS = "parameters";
    private final ActionExecutor actionExecutor;

    public ActionParametersFormPanel(String id, ActionModel model) {
        super(id, model);
        Ensure.ensureThatArg((Object)model.getExecutor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.actionExecutor = model.getExecutor();
        this.buildGui();
    }

    private void buildGui() {
        ActionModel model = (ActionModel)this.getModel();
        model.clearArguments();
        this.add(new Component[]{new ActionParameterForm("inputForm", model)});
    }

    class ActionParameterForm
    extends Form<ObjectAdapter>
    implements ScalarModelSubscriber {
        private static final long serialVersionUID = 1L;
        private static final String ID_FEEDBACK = "feedback";
        private final List<ScalarPanelAbstract> paramPanels;

        public ActionParameterForm(String id, ActionModel actionModel) {
            super(id, (IModel)actionModel);
            this.paramPanels = Lists.newArrayList();
            this.setOutputMarkupId(true);
            this.addParameters();
            FormFeedbackPanel formFeedback = new FormFeedbackPanel(ID_FEEDBACK);
            this.addOrReplace(new Component[]{formFeedback});
            this.addButtons();
        }

        private ActionModel getActionModel() {
            return (ActionModel)super.getModel();
        }

        private void addParameters() {
            ActionModel actionModel = this.getActionModel();
            List parameterMementos = actionModel.primeArgumentModels();
            RepeatingView rv = new RepeatingView(ActionParametersFormPanel.ID_ACTION_PARAMETERS);
            this.add(new Component[]{rv});
            this.paramPanels.clear();
            for (ActionParameterMemento apm : parameterMementos) {
                WebMarkupContainer container = new WebMarkupContainer(rv.newChildId());
                rv.add(new Component[]{container});
                ScalarModel argumentModel = actionModel.getArgumentModel(apm);
                argumentModel.setActionArgsHint(actionModel.getArgumentsAsArray());
                Component component = ActionParametersFormPanel.this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, ComponentType.SCALAR_NAME_AND_VALUE, (IModel<?>)argumentModel);
                ScalarPanelAbstract paramPanel = component instanceof ScalarPanelAbstract ? (ScalarPanelAbstract)component : null;
                this.paramPanels.add(paramPanel);
                if (paramPanel == null) continue;
                paramPanel.setOutputMarkupId(true);
                paramPanel.notifyOnChange(this);
            }
        }

        private void addButtons() {
            AjaxButton okButton = new AjaxButton(ActionParametersFormPanel.ID_OK_BUTTON, (IModel)new ResourceModel("okLabel")){
                private static final long serialVersionUID = 1L;

                public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    boolean succeeded = ActionParametersFormPanel.this.actionExecutor.executeActionAndProcessResults(target, form);
                    if (succeeded) {
                        target.appendJavaScript((CharSequence)"isisShowVeil();\n");
                        this.send((IEventSink)this.getPage(), Broadcast.EXACT, new IsisActionCompletedEvent(ActionParameterForm.this.getActionModel(), target, form));
                        target.add(new Component[]{form});
                    } else {
                        StringBuilder builder = new StringBuilder();
                        String errorMessagesIfAny = JGrowlUtil.asJGrowlCalls(IsisContext.getMessageBroker());
                        builder.append(errorMessagesIfAny);
                        String buf = builder.toString();
                        target.appendJavaScript((CharSequence)buf);
                        target.add(new Component[]{form});
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    super.onError(target, form);
                    target.add(new Component[]{form});
                }
            };
            okButton.add(new Behavior[]{new JGrowlBehaviour()});
            this.setDefaultButton((IFormSubmittingComponent)okButton);
            this.add(new Component[]{okButton});
            AjaxButton cancelButton = new AjaxButton(ActionParametersFormPanel.ID_CANCEL_BUTTON, (IModel)new ResourceModel("cancelLabel")){
                private static final long serialVersionUID = 1L;

                public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    ActionPrompt actionPromptIfAny = ActionPromptProvider.Util.getFrom((Component)ActionParametersFormPanel.this).getActionPrompt();
                    if (actionPromptIfAny != null) {
                        actionPromptIfAny.closePrompt(target);
                    }
                }
            };
            cancelButton.setDefaultFormProcessing(false);
            this.add(new Component[]{cancelButton});
            if (ActionPromptModalWindow.isActionPromptModalDialogDisabled()) {
                cancelButton.setVisible(false);
            }
        }

        @Override
        public void onUpdate(AjaxRequestTarget target, TextFieldValueModel.ScalarModelProvider provider) {
            ActionModel actionModel = this.getActionModel();
            ObjectAdapter[] pendingArguments = actionModel.getArgumentsAsArray();
            try {
                ObjectAction action = actionModel.getActionMemento().getAction();
                int numParams = action.getParameterCount();
                for (int i = 0; i < numParams; ++i) {
                    ScalarPanelAbstract paramPanel = this.paramPanels.get(i);
                    if (paramPanel == null || !paramPanel.updateChoices(pendingArguments)) continue;
                    target.add(new Component[]{paramPanel});
                }
            }
            catch (ConcurrencyException ex) {
                ObjectAdapter targetAdapter = this.getActionModel().getTargetAdapter();
                EntityPage entityPage = new EntityPage(targetAdapter, ex);
                ActionParametersFormPanel.this.setResponsePage((Page)entityPage);
                ActionParametersFormPanel.this.getAuthenticationSession().getMessageBroker().addWarning(ex.getMessage());
                return;
            }
        }

        @Override
        public void onError(AjaxRequestTarget target, TextFieldValueModel.ScalarModelProvider provider) {
            if (provider instanceof Component) {
                target.add(new Component[]{(Component)provider});
            }
        }
    }
}

