/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery.records;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ApplicationAttemptStateData {
    public static ApplicationAttemptStateData newInstance(ApplicationAttemptId attemptId, Container container, ByteBuffer attemptTokens, long startTime, RMAppAttemptState finalState, String finalTrackingUrl, String diagnostics, FinalApplicationStatus amUnregisteredFinalStatus, int exitStatus, long finishTime, long memorySeconds, long vcoreSeconds) {
        ApplicationAttemptStateData attemptStateData = (ApplicationAttemptStateData)Records.newRecord(ApplicationAttemptStateData.class);
        attemptStateData.setAttemptId(attemptId);
        attemptStateData.setMasterContainer(container);
        attemptStateData.setAppAttemptTokens(attemptTokens);
        attemptStateData.setState(finalState);
        attemptStateData.setFinalTrackingUrl(finalTrackingUrl);
        attemptStateData.setDiagnostics(diagnostics);
        attemptStateData.setStartTime(startTime);
        attemptStateData.setFinalApplicationStatus(amUnregisteredFinalStatus);
        attemptStateData.setAMContainerExitStatus(exitStatus);
        attemptStateData.setFinishTime(finishTime);
        attemptStateData.setMemorySeconds(memorySeconds);
        attemptStateData.setVcoreSeconds(vcoreSeconds);
        return attemptStateData;
    }

    public static ApplicationAttemptStateData newInstance(RMStateStore.ApplicationAttemptState attemptState) throws IOException {
        Credentials credentials = attemptState.getAppAttemptCredentials();
        ByteBuffer appAttemptTokens = null;
        if (credentials != null) {
            DataOutputBuffer dob = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            appAttemptTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        }
        return ApplicationAttemptStateData.newInstance(attemptState.getAttemptId(), attemptState.getMasterContainer(), appAttemptTokens, attemptState.getStartTime(), attemptState.getState(), attemptState.getFinalTrackingUrl(), attemptState.getDiagnostics(), attemptState.getFinalApplicationStatus(), attemptState.getAMContainerExitStatus(), attemptState.getFinishTime(), attemptState.getMemorySeconds(), attemptState.getVcoreSeconds());
    }

    public abstract YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto getProto();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ApplicationAttemptId getAttemptId();

    public abstract void setAttemptId(ApplicationAttemptId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Container getMasterContainer();

    public abstract void setMasterContainer(Container var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ByteBuffer getAppAttemptTokens();

    public abstract void setAppAttemptTokens(ByteBuffer var1);

    public abstract RMAppAttemptState getState();

    public abstract void setState(RMAppAttemptState var1);

    public abstract String getFinalTrackingUrl();

    public abstract void setFinalTrackingUrl(String var1);

    public abstract String getDiagnostics();

    public abstract void setDiagnostics(String var1);

    public abstract long getStartTime();

    public abstract void setStartTime(long var1);

    public abstract FinalApplicationStatus getFinalApplicationStatus();

    public abstract void setFinalApplicationStatus(FinalApplicationStatus var1);

    public abstract int getAMContainerExitStatus();

    public abstract void setAMContainerExitStatus(int var1);

    public abstract long getFinishTime();

    public abstract void setFinishTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getMemorySeconds();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setMemorySeconds(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getVcoreSeconds();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setVcoreSeconds(long var1);
}

