/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.trigger;

import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.trigger.StoredProcedureOption;

public class StoredProcedureSearchContextOption
implements StoredProcedureOption {
    private final Dn baseObject;
    private SearchScope searchScope;

    public StoredProcedureSearchContextOption(Dn baseObject) {
        this(baseObject, SearchScope.OBJECT);
    }

    public StoredProcedureSearchContextOption(Dn baseObject, SearchScope searchScope) {
        this.baseObject = baseObject;
        this.searchScope = searchScope;
    }

    public Dn getBaseObject() {
        return this.baseObject;
    }

    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    public String toString() {
        return "searchContext { scope " + this.searchScope + " } \"" + this.baseObject + "\"";
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + (this.baseObject == null ? 0 : this.baseObject.hashCode());
        h = h * 17 + (this.searchScope == null ? 0 : this.searchScope.hashCode());
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoredProcedureSearchContextOption other = (StoredProcedureSearchContextOption)obj;
        if (this.baseObject == null ? other.baseObject != null : !this.baseObject.equals((Object)other.baseObject)) {
            return false;
        }
        return !(this.searchScope == null ? other.searchScope != null : !this.searchScope.equals((Object)other.searchScope));
    }
}

