/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAnnotationElement {
    private String name;
    private Object value;
    private boolean isPrimitive;
    private Set<String> imports = new HashSet<String>();

    public JAnnotationElement() {
    }

    public JAnnotationElement(String n, Object v) {
        this(n, v, false);
    }

    public JAnnotationElement(String n, Object v, boolean primitive) {
        this.name = n;
        this.value = v;
        this.isPrimitive = primitive;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        this.value = newValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.value != null) {
            if (this.name != null) {
                sb.append(" = ");
            }
            if (this.value instanceof List) {
                List list = (List)this.value;
                sb.append("{");
                for (int i = 0; i < list.size(); ++i) {
                    this.appendValue(sb, list.get(i));
                    if (i >= list.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append("}");
            } else if (this.value instanceof String[]) {
                sb.append("{");
                for (int i = 0; i < Array.getLength(this.value); ++i) {
                    this.appendValue(sb, Array.get(this.value, i));
                    if (i >= Array.getLength(this.value) - 1) continue;
                    sb.append(", ");
                }
                sb.append("}");
            } else {
                this.appendValue(sb, this.value);
            }
        }
        return sb.toString();
    }

    private void appendValue(StringBuilder sb, Object obj) {
        if (obj instanceof String) {
            if (this.isPrimitive) {
                sb.append(obj);
            } else {
                this.getStringValue(sb, obj);
            }
        } else if (obj instanceof Class) {
            Class clz = (Class)obj;
            if (this.containsSameClassName(clz) && !this.imports.contains(clz.getName())) {
                sb.append(clz.getName());
            } else {
                sb.append(clz.getSimpleName());
                this.imports.add(clz.getName());
            }
            sb.append(".class");
        } else if (obj instanceof JAnnotation) {
            sb.append(obj);
            this.imports.addAll(((JAnnotation)obj).getImports());
        } else if (obj instanceof Enum) {
            this.appendEnumValue(sb, obj);
        } else if (obj instanceof JavaType) {
            JavaType type = (JavaType)obj;
            sb.append(type.getClassName());
            sb.append(".class");
        } else if (this.isPrimitive) {
            sb.append(obj);
        }
    }

    private void appendEnumValue(StringBuilder sb, Object obj) {
        Enum e = (Enum)obj;
        String clzName = e.getClass().getName();
        if (clzName.contains("$")) {
            this.imports.add(obj.getClass().getName().substring(0, clzName.lastIndexOf("$")));
        } else {
            this.imports.add(obj.getClass().getName());
        }
        sb.append(clzName.substring(clzName.lastIndexOf(".") + 1).replace("$", "."));
        sb.append(".");
        sb.append(e.name());
    }

    private void getStringValue(StringBuilder sb, Object obj) {
        sb.append("\"");
        sb.append(obj);
        sb.append("\"");
    }

    private boolean containsSameClassName(Class clz) {
        return this.imports.contains(clz.getName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JAnnotationElement)) {
            return false;
        }
        JAnnotationElement element = (JAnnotationElement)obj;
        return element.toString().equals(this.toString());
    }
}

