/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.SystemUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.maven_plugin.ClassLoaderSwitcher;
import org.apache.cxf.tools.common.CommandInterfaceUtils;
import org.apache.cxf.tools.java2ws.JavaToWS;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class Java2WSMojo
extends AbstractMojo {
    private String className;
    private String classpath;
    private String outputFile;
    private Boolean soap12;
    private String targetNamespace;
    private String serviceName;
    private Boolean verbose;
    private Boolean quiet;
    private String address;
    private String classifier;
    private List<?> classpathElements;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private String argline;
    private String frontend;
    private String databinding;
    private Boolean genWsdl;
    private Boolean genServer;
    private Boolean genClient;
    private Boolean genWrapperbean;
    private String portName;
    private Boolean attachWsdl;
    private List<Artifact> pluginArtifacts;
    private Boolean skip;
    private Boolean fork;
    private String javaExecutable;
    private String additionalJvmArgs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        System.setProperty("org.apache.cxf.JDKBugHacks.defaultUsesCaches", "true");
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping Java2WS execution");
            return;
        }
        ClassLoaderSwitcher classLoaderSwitcher = new ClassLoaderSwitcher(this.getLog());
        try {
            String cp = classLoaderSwitcher.switchClassLoader(this.project, false, this.classpath, this.classpathElements);
            if (this.fork.booleanValue()) {
                ArrayList<String> artifactsPath = new ArrayList<String>(this.pluginArtifacts.size());
                for (Artifact a : this.pluginArtifacts) {
                    File file = a.getFile();
                    if (file == null) {
                        throw new MojoExecutionException("Unable to find file for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
                    }
                    artifactsPath.add(file.getPath());
                }
                cp = StringUtils.join(artifactsPath.iterator(), (String)File.pathSeparator) + File.pathSeparator + cp;
            }
            List<String> args = this.initArgs(cp);
            this.processJavaClass(args);
        }
        finally {
            classLoaderSwitcher.restoreClassLoader();
        }
        System.gc();
    }

    private List<String> initArgs(String cp) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.fork.booleanValue()) {
            args.add(this.additionalJvmArgs);
            args.add("-DexitOnFinish=true");
        }
        args.add("-cp");
        args.add(cp);
        if (this.fork.booleanValue()) {
            args.add(JavaToWS.class.getCanonicalName());
        }
        if (this.outputFile == null && this.project != null) {
            int i = this.className.lastIndexOf(46);
            String name = this.className.substring(i + 1);
            this.outputFile = (this.project.getBuild().getDirectory() + "/generated/wsdl/" + name + ".wsdl").replace("/", File.separator);
        }
        if (this.outputFile != null) {
            FileUtils.mkDir((File)new File(this.outputFile).getParentFile());
            args.add("-o");
            args.add(this.outputFile);
            if (this.project != null) {
                this.project.addCompileSourceRoot(new File(this.outputFile).getParentFile().getAbsolutePath());
            }
        }
        if (!StringUtils.isEmpty((String)this.frontend)) {
            args.add("-frontend");
            args.add(this.frontend);
        }
        if (!StringUtils.isEmpty((String)this.databinding)) {
            args.add("-databinding");
            args.add(this.databinding);
        }
        if (this.genWrapperbean.booleanValue()) {
            args.add("-wrapperbean");
        }
        if (this.genWsdl.booleanValue()) {
            args.add("-wsdl");
        }
        if (this.genServer.booleanValue()) {
            args.add("-server");
        }
        if (this.genClient.booleanValue()) {
            args.add("-client");
        }
        if (this.soap12 != null && this.soap12.booleanValue()) {
            args.add("-soap12");
        }
        if (!StringUtils.isEmpty((String)this.targetNamespace)) {
            args.add("-t");
            args.add(this.targetNamespace);
        }
        if (!StringUtils.isEmpty((String)this.serviceName)) {
            args.add("-servicename");
            args.add(this.serviceName);
        }
        if (this.verbose != null && this.verbose.booleanValue()) {
            args.add("-verbose");
        }
        if (this.quiet != null && this.quiet.booleanValue()) {
            args.add("-quiet");
        }
        if (!StringUtils.isEmpty((String)this.address)) {
            args.add("-address");
            args.add(this.address);
        }
        if (!StringUtils.isEmpty((String)this.portName)) {
            args.add("-portname");
            args.add(this.portName);
        }
        if (this.argline != null) {
            StringTokenizer stoken = new StringTokenizer(this.argline, " ");
            while (stoken.hasMoreTokens()) {
                args.add(stoken.nextToken());
            }
        }
        args.add(this.className);
        return args;
    }

    private void processJavaClass(List<String> args) throws MojoExecutionException {
        File wsdlFile;
        int exitCode;
        if (!this.fork.booleanValue()) {
            try {
                CommandInterfaceUtils.commandCommonMain();
                JavaToWS j2w = new JavaToWS(args.toArray(new String[args.size()]));
                j2w.run();
            }
            catch (OutOfMemoryError e) {
                this.getLog().debug((Throwable)e);
                StringBuilder msg = new StringBuilder();
                msg.append(e.getMessage()).append('\n');
                msg.append("Try to run this goal using the <fork>true</fork> and <additionalJvmArgs>-Xms128m -Xmx128m</additionalJvmArgs> parameters.");
                throw new MojoExecutionException(msg.toString(), (Throwable)e);
            }
            catch (Throwable e) {
                this.getLog().debug(e);
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        this.getLog().info((CharSequence)"Running java2ws in fork mode...");
        Commandline cmd = new Commandline();
        cmd.getShell().setQuotedArgumentsEnabled(true);
        cmd.setWorkingDirectory(this.project.getBuild().getDirectory());
        try {
            cmd.setExecutable(this.getJavaExecutable().getAbsolutePath());
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        cmd.addArguments(args.toArray(new String[args.size()]));
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        String output = StringUtils.isEmpty((String)out.getOutput()) ? null : '\n' + out.getOutput().trim();
        String cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline());
        if (exitCode != 0) {
            if (StringUtils.isNotEmpty((String)output)) {
                this.getLog().info((CharSequence)output);
            }
            StringBuilder msg = new StringBuilder("\nExit code: ");
            msg.append(exitCode);
            if (StringUtils.isNotEmpty((String)err.getOutput())) {
                msg.append(" - ").append(err.getOutput());
            }
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
        if (StringUtils.isNotEmpty((String)err.getOutput()) && err.getOutput().contains("JavaToWS Error")) {
            StringBuilder msg = new StringBuilder();
            msg.append(err.getOutput());
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
        if (this.attachWsdl.booleanValue() && this.outputFile != null && (wsdlFile = new File(this.outputFile)).exists()) {
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, wsdlFile.getName(), this.classifier, wsdlFile);
            } else {
                this.projectHelper.attachArtifact(this.project, wsdlFile.getName(), wsdlFile);
            }
            boolean hasWsdlAttached = false;
            for (Artifact a : this.project.getAttachedArtifacts()) {
                if (!"wsdl".equals(a.getType())) continue;
                hasWsdlAttached = true;
            }
            if (!hasWsdlAttached) {
                if (this.classifier != null) {
                    this.projectHelper.attachArtifact(this.project, "wsdl", this.classifier, wsdlFile);
                } else {
                    this.projectHelper.attachArtifact(this.project, "wsdl", wsdlFile);
                }
            }
        }
    }

    private File getJavaExecutable() throws IOException {
        String exe = SystemUtils.IS_OS_WINDOWS && !this.javaExecutable.endsWith(".exe") ? ".exe" : "";
        File javaExe = new File(this.javaExecutable + exe);
        if (!javaExe.isFile()) {
            throw new IOException("The java executable '" + javaExe + "' doesn't exist or is not a file. Verify the <javaExecutable/> parameter.");
        }
        return javaExe;
    }
}

