/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.sax;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.cocoon.xml.sax.SAXBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamSAXBuffer
extends SAXBuffer {
    private char[] prevChar = null;

    public ParamSAXBuffer() {
    }

    public ParamSAXBuffer(SAXBuffer saxBuffer) {
        super(saxBuffer);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.prevChar != null) {
            char[] buf = new char[length + this.prevChar.length];
            System.arraycopy(this.prevChar, 0, buf, 0, this.prevChar.length);
            System.arraycopy(ch, start, buf, this.prevChar.length, length);
            ch = buf;
            start = 0;
            length += this.prevChar.length;
            this.prevChar = null;
        }
        int end = start + length;
        for (int i = start; i < end; ++i) {
            int j;
            if (ch[i] != '{') continue;
            if (i > start) {
                this.addBit(new SAXBuffer.Characters(ch, start, i - start));
            }
            StringBuilder name = new StringBuilder();
            for (j = i + 1; j < end && ch[j] != '}'; ++j) {
                name.append(ch[j]);
            }
            if (j == end) {
                this.prevChar = new char[end - i];
                System.arraycopy(ch, i, this.prevChar, 0, end - i);
                return;
            }
            this.addBit(new Parameter(name.toString()));
            i = j;
            start = j + 1;
        }
        if (start < end) {
            this.addBit(new SAXBuffer.Characters(ch, start, end - start));
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.flushChars();
        super.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.flushChars();
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.flushChars();
        super.processingInstruction(target, data);
    }

    @Override
    public void startDocument() throws SAXException {
        this.flushChars();
        super.startDocument();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.flushChars();
        super.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endDocument() throws SAXException {
        this.flushChars();
        super.endDocument();
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushChars();
        super.comment(ch, start, length);
    }

    @Override
    public void endDTD() throws SAXException {
        this.flushChars();
        super.endDTD();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.flushChars();
        super.startDTD(name, publicId, systemId);
    }

    private void flushChars() {
        if (this.prevChar != null) {
            this.addBit(new SAXBuffer.Characters(this.prevChar, 0, this.prevChar.length));
            this.prevChar = null;
        }
    }

    public void toSAX(ContentHandler contentHandler, Map<String, SAXBuffer> parameters) throws SAXException {
        for (SAXBuffer.SaxBit saxbit : this.saxbits) {
            if (saxbit instanceof Parameter) {
                ((Parameter)saxbit).send(contentHandler, parameters);
                continue;
            }
            saxbit.send(contentHandler);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Parameter
    implements SAXBuffer.SaxBit {
        private final String name;

        public Parameter(String name) {
            this.name = name;
        }

        @Override
        public void send(ContentHandler contentHandler) {
        }

        public void send(ContentHandler contentHandler, Map<String, SAXBuffer> parameters) throws SAXException {
            SAXBuffer value = parameters.get(this.name);
            if (value != null) {
                value.toSAX(contentHandler);
            }
        }

        public void toString(StringBuilder result, Map<String, String> parameters) throws SAXException {
            String value = parameters.get(this.name);
            if (value != null) {
                result.append(value);
            }
        }

        @Override
        public void dump(Writer writer) throws IOException {
            writer.write("[Parameter] name=" + this.name);
        }
    }
}

