/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.cocoon.configuration.MutableSettings;
import org.apache.cocoon.configuration.PropertyHelper;
import org.apache.cocoon.configuration.PropertyProvider;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.spring.configurator.ResourceUtils;
import org.apache.cocoon.spring.configurator.impl.SettingsProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextResourceLoader;

public abstract class AbstractSettingsBeanFactoryPostProcessor
extends PropertyPlaceholderConfigurer
implements ServletContextAware,
ResourceLoaderAware,
FactoryBean {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected ServletContext servletContext;
    protected MutableSettings settings;
    protected BeanFactory beanFactory;
    protected ResourceLoader resourceLoader;
    protected Properties additionalProperties;
    protected List directories;

    public void setBeanFactory(BeanFactory factory) {
        super.setBeanFactory(factory);
        this.beanFactory = factory;
    }

    public void setServletContext(ServletContext sContext) {
        this.servletContext = sContext;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.resourceLoader = loader;
    }

    public void setDirectories(List directories) {
        this.directories = directories;
    }

    public void setAdditionalProperties(Properties props) {
        this.additionalProperties = props;
    }

    public void init() throws Exception {
        this.settings = this.createSettings();
        this.dumpSettings();
    }

    protected abstract String getRunningMode();

    protected Settings getParentSettings() {
        BeanFactory parentBeanFactory = ((HierarchicalBeanFactory)this.beanFactory).getParentBeanFactory();
        if (parentBeanFactory != null) {
            return (Settings)parentBeanFactory.getBean(Settings.ROLE);
        }
        return null;
    }

    protected MutableSettings createMutableSettingsInstance() {
        Settings parentSettings = this.getParentSettings();
        if (parentSettings == null) {
            return new MutableSettings(this.getRunningMode());
        }
        return new MutableSettings(parentSettings);
    }

    protected void preInit(MutableSettings s, Properties properties) {
    }

    protected void postInit(MutableSettings s, Properties properties) {
    }

    protected String getNameForPropertyProvider() {
        return null;
    }

    protected MutableSettings createSettings() {
        String mode = this.getRunningMode();
        MutableSettings s = this.createMutableSettingsInstance();
        Properties properties = new Properties();
        this.preInit(s, properties);
        if (this.beanFactory != null && this.beanFactory.containsBean(PropertyProvider.ROLE)) {
            try {
                PropertyProvider provider = (PropertyProvider)this.beanFactory.getBean(PropertyProvider.ROLE);
                Properties providedProperties = provider.getProperties((Settings)s, mode, this.getNameForPropertyProvider());
                if (providedProperties != null) {
                    properties.putAll((Map<?, ?>)providedProperties);
                }
            }
            catch (Exception ignore) {
                this.logger.warn((Object)"Unable to get properties from provider.", (Throwable)ignore);
                this.logger.warn((Object)"Continuing initialization.");
            }
        }
        if (this.directories != null) {
            Iterator i = this.directories.iterator();
            while (i.hasNext()) {
                String directory = (String)i.next();
                ResourceUtils.readProperties(directory, properties, this.getResourceLoader(), this.logger);
                ResourceUtils.readProperties(directory + '/' + mode, properties, this.getResourceLoader(), this.logger);
            }
        }
        if (this.additionalProperties != null) {
            PropertyHelper.replaceAll((Properties)this.additionalProperties, (Settings)s);
            properties.putAll((Map<?, ?>)this.additionalProperties);
        }
        try {
            properties.putAll((Map<?, ?>)System.getProperties());
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this.postInit(s, properties);
        PropertyHelper.replaceAll((Properties)properties, (Settings)this.getParentSettings());
        s.configure(properties);
        s.makeReadOnly();
        return s;
    }

    protected ResourceLoader getResourceLoader() {
        if (this.resourceLoader != null) {
            return this.resourceLoader;
        }
        if (this.servletContext != null) {
            return new ServletContextResourceLoader(this.servletContext);
        }
        return new FileSystemResourceLoader();
    }

    protected String getSystemProperty(String key) {
        return this.getSystemProperty(key, null);
    }

    protected String getSystemProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        CocoonSettingsResolvingBeanDefinitionVisitor visitor = new CocoonSettingsResolvingBeanDefinitionVisitor((Settings)this.settings);
        String[] beanNames = beanFactoryToProcess.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            BeanDefinition bd = beanFactoryToProcess.getBeanDefinition(beanNames[i]);
            try {
                visitor.visitBeanDefinition(bd);
                continue;
            }
            catch (BeanDefinitionStoreException e) {
                throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanNames[i], (Throwable)e);
            }
        }
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        return PropertyHelper.getProperty((String)placeholder, (Properties)props, null);
    }

    protected void dumpSettings() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"===== Settings Start =====");
            this.logger.debug((Object)this.settings.toString());
            List names = this.settings.getPropertyNames();
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                this.logger.debug((Object)("Property: " + name + "=" + this.settings.getProperty(name)));
            }
            this.logger.debug((Object)"===== Settings End =====");
        }
    }

    public Object getObject() throws Exception {
        return this.settings;
    }

    public Class getObjectType() {
        return Settings.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected class CocoonSettingsResolvingBeanDefinitionVisitor
    extends BeanDefinitionVisitor {
        protected final Properties props;
        protected final Set visitedPlaceholders = new HashSet();

        public CocoonSettingsResolvingBeanDefinitionVisitor(Settings settings) {
            this.props = new SettingsProperties(settings);
        }

        protected String resolveStringValue(String strVal) {
            return AbstractSettingsBeanFactoryPostProcessor.this.parseStringValue(strVal, this.props, this.visitedPlaceholders);
        }
    }
}

