/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.exception;

import com.alibaba.fastjson.JSONObject;
import com.mingsoft.base.entity.ResultJson;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.base.util.BaseUtil;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class SimpleMappingExceptionResolver
implements HandlerExceptionResolver {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMappingExceptionResolver.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object object, Exception exception) {
        if (request.getHeader("accept").indexOf("application/json") <= -1 && (request.getHeader("X-Requested-With") == null || request.getHeader("X-Requested-With").indexOf("XMLHttpRequest") <= -1)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("result", false);
            if (exception instanceof BusinessException) {
                map.put("resultMsg", exception.getMessage());
            } else {
                if (exception instanceof UnauthorizedException) {
                    map.put("resultMsg", "err.not.permissions");
                    return new ModelAndView("redirect:/error/403.do", map);
                }
                map.put("resultMsg", exception.getMessage());
            }
            BaseUtil.setSession("ms_exception", (Object)exception);
            return new ModelAndView("redirect:/error/500.do", map);
        }
        try {
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter writer = response.getWriter();
            ResultJson result = new ResultJson();
            result.setResult(false);
            if (exception instanceof BusinessException) {
                result.setResultMsg(exception.getMessage());
            } else if (exception instanceof UnauthorizedException) {
                result.setResultMsg("err.not.permissions");
            } else {
                result.setResultMsg("error");
            }
            writer.write(JSONObject.toJSONString((Object)result));
            writer.flush();
            writer.close();
            LOG.debug("ajax\u8bf7\u6c42 \u5f02\u5e38");
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error(e.getMessage());
        }
        return null;
    }
}

