/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import net.bull.javamelody.JavaMelodyConfigurationProperties;
import net.bull.javamelody.MonitoredWithAnnotationPointcut;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.MonitoringSpringAdvisor;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.SpringDataSourceBeanPostProcessor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@EnableConfigurationProperties(value={JavaMelodyConfigurationProperties.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="javamelody", name={"enabled"}, matchIfMissing=true)
public class JavaMelodyAutoConfiguration {
    public static final String REGISTRATION_BEAN_NAME = "javamelody-registration";

    @Bean
    public SessionListener monitoringSessionListener() {
        return new SessionListener();
    }

    @Bean(name={"javamelody-registration"})
    @ConditionalOnMissingBean(name={"javamelody-registration"})
    public FilterRegistrationBean monitoringFilter(JavaMelodyConfigurationProperties properties) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        MonitoringFilter filter = new MonitoringFilter();
        filter.setApplicationType("Spring Boot");
        registrationBean.setFilter((Filter)filter);
        registrationBean.setAsyncSupported(true);
        registrationBean.setName("javamelody");
        registrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        for (Map.Entry<String, String> parameter : properties.getInitParameters().entrySet()) {
            registrationBean.addInitParameter(parameter.getKey(), parameter.getValue());
        }
        registrationBean.addUrlPatterns(new String[]{"/*"});
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultAdvisorAutoProxyCreator.class})
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        return new DefaultAdvisorAutoProxyCreator();
    }

    @Bean
    public SpringDataSourceBeanPostProcessor monitoringDataSourceBeanPostProcessor(@Value(value="${javamelody.excluded-datasources:}") String excludedDatasources) {
        SpringDataSourceBeanPostProcessor processor = new SpringDataSourceBeanPostProcessor();
        if (excludedDatasources != null && excludedDatasources.trim().length() > 0) {
            processor.setExcludedDatasources(new HashSet<String>(Arrays.asList(excludedDatasources.split(","))));
        }
        return processor;
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringAdvisor() {
        MonitoringSpringAdvisor interceptor = new MonitoringSpringAdvisor();
        interceptor.setPointcut((Pointcut)new MonitoredWithAnnotationPointcut());
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringServiceAdvisor() {
        MonitoringSpringAdvisor interceptor = new MonitoringSpringAdvisor();
        interceptor.setPointcut((Pointcut)new AnnotationMatchingPointcut(Service.class));
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringControllerAdvisor() {
        MonitoringSpringAdvisor interceptor = new MonitoringSpringAdvisor();
        interceptor.setPointcut((Pointcut)new AnnotationMatchingPointcut(Controller.class));
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringRestControllerAdvisor() {
        MonitoringSpringAdvisor interceptor = new MonitoringSpringAdvisor();
        interceptor.setPointcut((Pointcut)new AnnotationMatchingPointcut(RestController.class));
        return interceptor;
    }
}

