/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.dynamic.Callable;
import com.mockobjects.dynamic.Mock;
import junit.framework.AssertionFailedError;

public class CallOnceExpectation
implements Callable {
    private Callable delegate;
    private boolean wasCalled = false;

    public CallOnceExpectation(Callable delegate) {
        this.delegate = delegate;
    }

    public String getDescription() {
        return this.delegate.getDescription() + " [" + (this.wasCalled ? "" : "not ") + "called]";
    }

    public Object call(Mock mock, String methodName, Object[] args) throws Throwable {
        this.wasCalled = true;
        return this.delegate.call(mock, methodName, args);
    }

    public boolean matches(String methodName, Object[] args) {
        return !this.wasCalled && this.delegate.matches(methodName, args);
    }

    public void verify() {
        if (!this.wasCalled) {
            throw new AssertionFailedError(this.delegate.getDescription() + " was expected but not called");
        }
        this.delegate.verify();
    }

    public String toString() {
        return Mock.className(this.getClass()) + "(" + this.getDescription() + ")";
    }
}

