/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.constraint.And;
import com.mockobjects.constraint.Constraint;
import com.mockobjects.constraint.IsAnything;
import com.mockobjects.constraint.IsEqual;
import com.mockobjects.constraint.IsGreaterThan;
import com.mockobjects.constraint.IsInstanceOf;
import com.mockobjects.constraint.IsLessThan;
import com.mockobjects.constraint.IsNot;
import com.mockobjects.constraint.IsNull;
import com.mockobjects.constraint.IsSame;
import com.mockobjects.constraint.Or;
import com.mockobjects.dynamic.AnyConstraintMatcher;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.FullConstraintMatcher;

public abstract class C {
    public static final IsAnything IS_ANYTHING = new IsAnything();
    public static final IsNull IS_NULL = new IsNull();
    public static final Constraint IS_NOT_NULL = C.not(IS_NULL);
    public static final Constraint IS_TRUE = C.eq(new Boolean(true));
    public static final Constraint IS_FALSE = C.eq(new Boolean(false));
    public static final Constraint IS_ZERO = C.eq(new Integer(0));
    public static final Constraint IS_NOT_ZERO = C.not(IS_ZERO);
    public static final ConstraintMatcher NO_ARGS = new FullConstraintMatcher(new Constraint[0]);
    public static final ConstraintMatcher ANY_ARGS = new AnyConstraintMatcher();

    public static Constraint same(Object o) {
        return new IsSame(o);
    }

    public static Constraint eq(Object o) {
        return new IsEqual(o);
    }

    public static ConstraintMatcher eq(Object arg0, Object arg1) {
        return C.args(C.eq(arg0), C.eq(arg1));
    }

    public static ConstraintMatcher eq(Object arg0, Object arg1, Object arg2) {
        return C.args(C.eq(arg0), C.eq(arg1), C.eq(arg2));
    }

    public static Constraint eq(int n) {
        return new IsEqual(new Integer(n));
    }

    public static Constraint eq(long l) {
        return new IsEqual(new Long(l));
    }

    public static Constraint eq(double d) {
        return new IsEqual(new Double(d));
    }

    public static Constraint gt(int n) {
        return new IsGreaterThan(new Integer(n));
    }

    public static Constraint gt(long l) {
        return new IsGreaterThan(new Long(l));
    }

    public static Constraint gt(double d) {
        return new IsGreaterThan(new Double(d));
    }

    public static Constraint gt(char c) {
        return new IsGreaterThan(new Character(c));
    }

    public static Constraint lt(int n) {
        return new IsLessThan(new Integer(n));
    }

    public static Constraint lt(long l) {
        return new IsLessThan(new Long(l));
    }

    public static Constraint lt(double d) {
        return new IsLessThan(new Double(d));
    }

    public static Constraint lt(char c) {
        return new IsLessThan(new Character(c));
    }

    public static Constraint not(Constraint p) {
        return new IsNot(p);
    }

    public static Constraint and(Constraint p1, Constraint p2) {
        return new And(p1, p2);
    }

    public static Constraint or(Constraint p1, Constraint p2) {
        return new Or(p1, p2);
    }

    public static Constraint isA(Class c) {
        return new IsInstanceOf(c);
    }

    public static ConstraintMatcher args() {
        return NO_ARGS;
    }

    public static ConstraintMatcher args(Constraint p) {
        return new FullConstraintMatcher(new Constraint[]{p});
    }

    public static ConstraintMatcher args(Constraint p1, Constraint p2) {
        return new FullConstraintMatcher(new Constraint[]{p1, p2});
    }

    public static ConstraintMatcher args(Constraint p1, Constraint p2, Constraint p3) {
        return new FullConstraintMatcher(new Constraint[]{p1, p2, p3});
    }

    public static ConstraintMatcher anyArgs(int argCount) {
        Constraint[] constraints = new Constraint[argCount];
        int i = 0;
        while (i < constraints.length) {
            constraints[i] = new IsAnything();
            ++i;
        }
        return new FullConstraintMatcher(constraints);
    }
}

