/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.utils;

import java.text.MessageFormat;
import me.zhyd.oauth.consts.ApiUrl;

public class UrlBuilder {
    private static final String GITHUB_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&code={3}&redirect_uri={4}";
    private static final String GITHUB_USER_INFO_PATTERN = "{0}?access_token={1}";
    private static final String GITHUB_AUTHORIZE_PATTERN = "{0}?client_id={1}&state=1&redirect_uri={2}";
    private static final String GOOGLE_AUTHORIZE_PATTERN = "{0}?client_id={1}&response_type=code&scope=openid%20email%20profile&redirect_uri={2}&state={3}";
    private static final String GOOGLE_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&code={3}&redirect_uri={4}&grant_type=authorization_code";
    private static final String GOOGLE_USER_INFO_PATTERN = "{0}?id_token={1}";
    private static final String WEIBO_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}";
    private static final String WEIBO_USER_INFO_PATTERN = "{0}?{1}";
    private static final String WEIBO_AUTHORIZE_PATTERN = "{0}?client_id={1}&response_type=code&redirect_uri={2}";
    private static final String GITEE_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}";
    private static final String GITEE_USER_INFO_PATTERN = "{0}?access_token={1}";
    private static final String GITEE_AUTHORIZE_PATTERN = "{0}?client_id={1}&response_type=code&redirect_uri={2}";
    private static final String DING_TALK_QRCONNECT_PATTERN = "{0}?appid={1}&response_type=code&scope=snsapi_login&state=STATE&redirect_uri={2}";
    private static final String DING_TALK_USER_INFO_PATTERN = "{0}?signature={1}&timestamp={2}&accessKey={3}";
    private static final String BAIDU_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}";
    private static final String BAIDU_USER_INFO_PATTERN = "{0}?access_token={1}";
    private static final String BAIDU_AUTHORIZE_PATTERN = "{0}?client_id={1}&response_type=code&redirect_uri={2}&display=popup";
    private static final String BAIDU_REVOKE_PATTERN = "{0}?access_token={1}";
    private static final String CSDN_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}";
    private static final String CSDN_USER_INFO_PATTERN = "{0}?access_token={1}";
    private static final String CSDN_AUTHORIZE_PATTERN = "{0}?client_id={1}&response_type=code&redirect_uri={2}";
    private static final String CODING_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}";
    private static final String CODING_USER_INFO_PATTERN = "{0}?access_token={1}";
    private static final String CODING_AUTHORIZE_PATTERN = "{0}?client_id={1}&response_type=code&redirect_uri={2}&scope=user";
    private static final String TENCENT_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}";
    private static final String TENCENT_USER_INFO_PATTERN = "{0}?access_token={1}";
    private static final String TENCENT_AUTHORIZE_PATTERN = "{0}?client_id={1}&response_type=code&redirect_uri={2}&scope=user";
    private static final String OSCHINA_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}&dataType=json";
    private static final String OSCHINA_USER_INFO_PATTERN = "{0}?access_token={1}&dataType=json";
    private static final String OSCHINA_AUTHORIZE_PATTERN = "{0}?client_id={1}&response_type=code&redirect_uri={2}";
    private static final String ALIPAY_AUTHORIZE_PATTERN = "{0}?app_id={1}&scope=auth_user&redirect_uri={2}&state=init";
    private static final String QQ_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}";
    private static final String QQ_USER_INFO_PATTERN = "{0}?oauth_consumer_key={1}&access_token={2}&openid={3}";
    private static final String QQ_AUTHORIZE_PATTERN = "{0}?client_id={1}&response_type=code&redirect_uri={2}&state={3}";
    private static final String QQ_OPENID_PATTERN = "{0}?access_token={1}";
    private static final String WECHAT_AUTHORIZE_PATTERN = "{0}?appid={1}&redirect_uri={2}&response_type=code&scope=snsapi_login&state={3}#wechat_redirect";
    private static final String WECHAT_ACCESS_TOKEN_PATTERN = "{0}?appid={1}&secret={2}&code={3}&grant_type=authorization_code";
    private static final String WECHAT_REFRESH_TOKEN_PATTERN = "{0}?appid={1}&grant_type=refresh_token&refresh_token={2}";
    private static final String WECHAT_USER_INFO_PATTERN = "{0}?access_token={1}&openid={2}&lang=zh_CN";
    private static final String TAOBAO_AUTHORIZE_PATTERN = "{0}?response_type=code&client_id={1}&redirect_uri={2}&state={3}&view=web";
    private static final String TAOBAO_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&code={3}&redirect_uri={4}&grant_type=authorization_code";
    private static final String FACEBOOK_AUTHORIZE_PATTERN = "{0}?client_id={1}&redirect_uri={2}&state={3}&response_type=code&scope=";
    private static final String FACEBOOK_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&code={3}&redirect_uri={4}&grant_type=authorization_code";
    private static final String FACEBOOK_USER_INFO_PATTERN = "{0}?access_token={1}&fields=id,name,birthday,gender,hometown,email,devices,picture.width(400)";
    private static final String DOUYIN_AUTHORIZE_PATTERN = "{0}?client_key={1}&redirect_uri={2}&state={3}&response_type=code&scope=user_info";
    private static final String DOUYIN_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&code={3}&grant_type=authorization_code";
    private static final String DOUYIN_USER_INFO_PATTERN = "{0}?access_token={1}&open_id={2}";
    private static final String DOUYIN_REFRESH_TOKEN_PATTERN = "{0}?client_key={1}&refresh_token={2}&grant_type=refresh_token";
    private static final String LINKEDIN_AUTHORIZE_PATTERN = "{0}?client_id={1}&redirect_uri={2}&state={3}&response_type=code&scope=r_liteprofile%20r_emailaddress%20w_member_social";
    private static final String LINKEDIN_ACCESS_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&code={3}&redirect_uri={4}&grant_type=authorization_code";
    private static final String LINKEDIN_USER_INFO_PATTERN = "{0}?projection=(id,firstName,lastName,profilePicture(displayImage~:playableStreams))";
    private static final String LINKEDIN_REFRESH_TOKEN_PATTERN = "{0}?client_id={1}&client_secret={2}&refresh_token={3}&grant_type=refresh_token";

    public static String getGithubAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format(GITHUB_ACCESS_TOKEN_PATTERN, ApiUrl.GITHUB.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getGithubUserInfoUrl(String token) {
        return MessageFormat.format("{0}?access_token={1}", ApiUrl.GITHUB.userInfo(), token);
    }

    public static String getGithubAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(GITHUB_AUTHORIZE_PATTERN, ApiUrl.GITHUB.authorize(), clientId, redirectUrl);
    }

    public static String getWeiboAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}", ApiUrl.WEIBO.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getWeiboUserInfoUrl(String token) {
        return MessageFormat.format(WEIBO_USER_INFO_PATTERN, ApiUrl.WEIBO.userInfo(), token);
    }

    public static String getWeiboAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format("{0}?client_id={1}&response_type=code&redirect_uri={2}", ApiUrl.WEIBO.authorize(), clientId, redirectUrl);
    }

    public static String getGiteeAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}", ApiUrl.GITEE.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getGiteeUserInfoUrl(String token) {
        return MessageFormat.format("{0}?access_token={1}", ApiUrl.GITEE.userInfo(), token);
    }

    public static String getGiteeAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format("{0}?client_id={1}&response_type=code&redirect_uri={2}", ApiUrl.GITEE.authorize(), clientId, redirectUrl);
    }

    public static String getDingTalkQrConnectUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(DING_TALK_QRCONNECT_PATTERN, ApiUrl.DINGTALK.authorize(), clientId, redirectUrl);
    }

    public static String getDingTalkUserInfoUrl(String signature, String timestamp, String accessKey) {
        return MessageFormat.format(DING_TALK_USER_INFO_PATTERN, ApiUrl.DINGTALK.userInfo(), signature, timestamp, accessKey);
    }

    public static String getBaiduAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}", ApiUrl.BAIDU.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getBaiduUserInfoUrl(String token) {
        return MessageFormat.format("{0}?access_token={1}", ApiUrl.BAIDU.userInfo(), token);
    }

    public static String getBaiduAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(BAIDU_AUTHORIZE_PATTERN, ApiUrl.BAIDU.authorize(), clientId, redirectUrl);
    }

    public static String getBaiduRevokeUrl(String accessToken) {
        return MessageFormat.format("{0}?access_token={1}", ApiUrl.BAIDU.revoke(), accessToken);
    }

    public static String getCsdnAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}", ApiUrl.CSDN.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getCsdnUserInfoUrl(String token) {
        return MessageFormat.format("{0}?access_token={1}", ApiUrl.CSDN.userInfo(), token);
    }

    public static String getCsdnAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format("{0}?client_id={1}&response_type=code&redirect_uri={2}", ApiUrl.CSDN.authorize(), clientId, redirectUrl);
    }

    public static String getCodingAccessTokenUrl(String clientId, String clientSecret, String code) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}", ApiUrl.CODING.accessToken(), clientId, clientSecret, code);
    }

    public static String getCodingUserInfoUrl(String token) {
        return MessageFormat.format("{0}?access_token={1}", ApiUrl.CODING.userInfo(), token);
    }

    public static String getCodingAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format("{0}?client_id={1}&response_type=code&redirect_uri={2}&scope=user", ApiUrl.CODING.authorize(), clientId, redirectUrl);
    }

    public static String getTencentCloudAccessTokenUrl(String clientId, String clientSecret, String code) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}", ApiUrl.TENCENTCLOUD.accessToken(), clientId, clientSecret, code);
    }

    public static String getTencentCloudUserInfoUrl(String token) {
        return MessageFormat.format("{0}?access_token={1}", ApiUrl.TENCENTCLOUD.userInfo(), token);
    }

    public static String getTencentCloudAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format("{0}?client_id={1}&response_type=code&redirect_uri={2}&scope=user", ApiUrl.TENCENTCLOUD.authorize(), clientId, redirectUrl);
    }

    public static String getOschinaAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format(OSCHINA_ACCESS_TOKEN_PATTERN, ApiUrl.OSCHINA.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getOschinaUserInfoUrl(String token) {
        return MessageFormat.format(OSCHINA_USER_INFO_PATTERN, ApiUrl.OSCHINA.userInfo(), token);
    }

    public static String getOschinaAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format("{0}?client_id={1}&response_type=code&redirect_uri={2}", ApiUrl.OSCHINA.authorize(), clientId, redirectUrl);
    }

    public static String getQqAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&grant_type=authorization_code&code={3}&redirect_uri={4}", ApiUrl.QQ.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getQqUserInfoUrl(String clientId, String token, String openId) {
        return MessageFormat.format(QQ_USER_INFO_PATTERN, ApiUrl.QQ.userInfo(), clientId, token, openId);
    }

    public static String getQqAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(QQ_AUTHORIZE_PATTERN, ApiUrl.QQ.authorize(), clientId, redirectUrl, System.currentTimeMillis());
    }

    public static String getQqOpenidUrl(String url, String token) {
        return MessageFormat.format("{0}?access_token={1}", url, token);
    }

    public static String getAlipayAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(ALIPAY_AUTHORIZE_PATTERN, ApiUrl.ALIPAY.authorize(), clientId, redirectUrl);
    }

    public static String getWeChatAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(WECHAT_AUTHORIZE_PATTERN, ApiUrl.WECHAT.authorize(), clientId, redirectUrl, System.currentTimeMillis());
    }

    public static String getWeChatAccessTokenUrl(String clientId, String clientSecret, String code) {
        return MessageFormat.format(WECHAT_ACCESS_TOKEN_PATTERN, ApiUrl.WECHAT.accessToken(), clientId, clientSecret, code);
    }

    public static String getWeChatUserInfoUrl(String token, String openId) {
        return MessageFormat.format(WECHAT_USER_INFO_PATTERN, ApiUrl.WECHAT.userInfo(), token, openId);
    }

    public static String getWeChatRefreshUrl(String clientId, String refreshToken) {
        return MessageFormat.format(WECHAT_REFRESH_TOKEN_PATTERN, ApiUrl.WECHAT.refresh(), clientId, refreshToken);
    }

    public static String getTaobaoAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&code={3}&redirect_uri={4}&grant_type=authorization_code", ApiUrl.TAOBAO.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getTaobaoAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(TAOBAO_AUTHORIZE_PATTERN, ApiUrl.TAOBAO.authorize(), clientId, redirectUrl, System.currentTimeMillis());
    }

    public static String getGoogleAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(GOOGLE_AUTHORIZE_PATTERN, ApiUrl.GOOGLE.authorize(), clientId, redirectUrl, System.currentTimeMillis());
    }

    public static String getGoogleAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&code={3}&redirect_uri={4}&grant_type=authorization_code", ApiUrl.GOOGLE.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getGoogleUserInfoUrl(String token) {
        return MessageFormat.format(GOOGLE_USER_INFO_PATTERN, ApiUrl.GOOGLE.userInfo(), token);
    }

    public static String getFacebookAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(FACEBOOK_AUTHORIZE_PATTERN, ApiUrl.FACEBOOK.authorize(), clientId, redirectUrl, System.currentTimeMillis());
    }

    public static String getFacebookAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUri) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&code={3}&redirect_uri={4}&grant_type=authorization_code", ApiUrl.FACEBOOK.accessToken(), clientId, clientSecret, code, redirectUri);
    }

    public static String getFacebookUserInfoUrl(String token) {
        return MessageFormat.format(FACEBOOK_USER_INFO_PATTERN, ApiUrl.FACEBOOK.userInfo(), token);
    }

    public static String getDouyinAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(DOUYIN_AUTHORIZE_PATTERN, ApiUrl.DOUYIN.authorize(), clientId, redirectUrl, System.currentTimeMillis());
    }

    public static String getDouyinAccessTokenUrl(String clientId, String clientSecret, String code) {
        return MessageFormat.format(DOUYIN_ACCESS_TOKEN_PATTERN, ApiUrl.DOUYIN.accessToken(), clientId, clientSecret, code);
    }

    public static String getDouyinUserInfoUrl(String token, String openId) {
        return MessageFormat.format(DOUYIN_USER_INFO_PATTERN, ApiUrl.DOUYIN.userInfo(), token, openId);
    }

    public static String getDouyinRefreshUrl(String clientId, String refreshToken) {
        return MessageFormat.format(DOUYIN_REFRESH_TOKEN_PATTERN, ApiUrl.DOUYIN.refresh(), clientId, refreshToken);
    }

    public static String getLinkedinAuthorizeUrl(String clientId, String redirectUrl) {
        return MessageFormat.format(LINKEDIN_AUTHORIZE_PATTERN, ApiUrl.LINKEDIN.authorize(), clientId, redirectUrl, System.currentTimeMillis());
    }

    public static String getLinkedinAccessTokenUrl(String clientId, String clientSecret, String code, String redirectUrl) {
        return MessageFormat.format("{0}?client_id={1}&client_secret={2}&code={3}&redirect_uri={4}&grant_type=authorization_code", ApiUrl.LINKEDIN.accessToken(), clientId, clientSecret, code, redirectUrl);
    }

    public static String getLinkedinUserInfoUrl() {
        return MessageFormat.format(LINKEDIN_USER_INFO_PATTERN, ApiUrl.LINKEDIN.userInfo());
    }

    public static String getLinkedinRefreshUrl(String clientId, String clientSecret, String refreshToken) {
        return MessageFormat.format(LINKEDIN_REFRESH_TOKEN_PATTERN, ApiUrl.LINKEDIN.refresh(), clientId, clientSecret, refreshToken);
    }
}

