/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.model.AuthUserGender;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.request.ResponseStatus;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthWeChatRequest
extends BaseAuthRequest {
    public AuthWeChatRequest(AuthConfig config) {
        super(config, AuthSource.WECHAT);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getWeChatAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code);
        return this.getToken(accessTokenUrl);
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        String openId = authToken.getOpenId();
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getWeChatUserInfoUrl(accessToken, openId)).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        this.checkResponse(object);
        return AuthUser.builder().username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("headimgurl")).location(object.getString("country") + "-" + object.getString("province") + "-" + object.getString("city")).uuid(openId).gender(AuthUserGender.getRealGender(object.getString("sex"))).token(authToken).source(AuthSource.WECHAT).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        String refreshTokenUrl = UrlBuilder.getWeChatRefreshUrl(this.config.getClientId(), oldToken.getRefreshToken());
        return AuthResponse.builder().code(ResponseStatus.SUCCESS.getCode()).data(this.getToken(refreshTokenUrl)).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"errcode")) {
            throw new AuthException(object.getIntValue("errcode"), object.getString("errmsg"));
        }
    }

    private AuthToken getToken(String accessTokenUrl) {
        HttpResponse response = HttpRequest.get((String)accessTokenUrl).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        this.checkResponse(object);
        return AuthToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).openId(object.getString("openid")).build();
    }
}

